#!/bin/sh

# pack.sh: extracts from the subversion to a tarball.

ASCIIDOC="asciidoc -n" # set this to ':' if you don't have it

# Follow Debian and get the version from the changelog:
version=bristuff-`head -n 1 CHANGES`
tarball=$version.tar.gz
tarball_full=../$tarball
tmpdir=../pack
pack_dir=$tmpdir/$version


# Note: svn export expects the target dir not to exist
# but its parent to exist. Unlike e.g. cp.
mkdir -p $tmpdir
rm -rf $pack_dir
svn export . $pack_dir
$ASCIIDOC -a toc -a toclevels=3 -a revision="$version" $pack_dir/INSTALL || true
# use fakeroot to provide a tarball with files owned by root:
fakeroot tar czf $tarball_full -C $tmpdir $version

