/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jopendocument.dom.ContentTypeVersioned;
import org.jopendocument.dom.Manifest;
import org.jopendocument.dom.ODPackageEntry;
import org.jopendocument.dom.ODSingleXMLDocument;
import org.jopendocument.dom.ODXMLDocument;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.util.CopyUtils;
import org.jopendocument.util.FileUtils;
import org.jopendocument.util.StreamUtils;
import org.jopendocument.util.StringInputStream;
import org.jopendocument.util.Zip;
import org.jopendocument.util.ZippedFilesProcessor;

public class ODPackage {
    private static final XMLOutputter OUTPUTTER = new XMLOutputter(Format.getRawFormat());
    private static final Set<String> subdocNames = new HashSet<String>();
    private final Map<String, ODPackageEntry> files = new HashMap<String, ODPackageEntry>();
    private ContentTypeVersioned type = null;
    private File file = null;

    static {
        subdocNames.add("content.xml");
        subdocNames.add("styles.xml");
        subdocNames.add("meta.xml");
        subdocNames.add("settings.xml");
    }

    public static final boolean isStandardFile(String name) {
        return name.equals("mimetype") || subdocNames.contains(name) || name.startsWith("Thumbnails") || name.startsWith("META-INF") || name.startsWith("Configurations");
    }

    public ODPackage() {
    }

    public ODPackage(InputStream ins) throws IOException {
        this();
        final ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        new ZippedFilesProcessor(){

            @Override
            protected void processEntry(String name, InputStream in) throws IOException {
                Object res;
                if (subdocNames.contains(name)) {
                    try {
                        res = new ODXMLDocument(OOUtils.getBuilder().build(in));
                    }
                    catch (JDOMException e) {
                        throw new IllegalStateException("parse error", e);
                    }
                } else {
                    out.reset();
                    StreamUtils.copy(in, out);
                    res = out.toByteArray();
                }
                ODPackage.this.putFile(name, res, null);
            }
        }.process(ins);
        ODPackageEntry me = this.files.remove("META-INF/manifest.xml");
        if (me != null) {
            byte[] m = (byte[])me.getData();
            try {
                Map<String, String> manifestEntries = Manifest.parse(new ByteArrayInputStream(m));
                for (Map.Entry<String, String> e : manifestEntries.entrySet()) {
                    String path = e.getKey();
                    ODPackageEntry entry = this.files.get(path);
                    if (entry == null) {
                        this.files.put(path, new ODPackageEntry(path, e.getValue(), null));
                        continue;
                    }
                    entry.setType(e.getValue());
                }
            }
            catch (JDOMException e) {
                throw new IllegalArgumentException("bad manifest " + new String(m), e);
            }
        }
    }

    public ODPackage(File f) throws IOException {
        this(new BufferedInputStream(new FileInputStream(f), 524288));
        this.file = f;
    }

    public ODPackage(ODPackage o) {
        this();
        for (String name : o.getEntries()) {
            Object data = o.getData(name);
            Object myData = data instanceof byte[] ? data : (data instanceof ODSingleXMLDocument ? new ODSingleXMLDocument((ODSingleXMLDocument)data, this) : CopyUtils.copy(data));
            this.putFile(name, myData, o.getEntry(name).getType());
        }
        this.file = o.file;
    }

    public final File getFile() {
        return this.file;
    }

    public final void setFile(File f) {
        this.file = this.addExt(f);
    }

    private final File addExt(File f) {
        String ext = String.valueOf('.') + this.getContentType().getExtension();
        if (!f.getName().endsWith(ext)) {
            f = new File(f.getParentFile(), String.valueOf(f.getName()) + ext);
        }
        return f;
    }

    public final String getVersion() {
        if (this.getContent() == null) {
            return null;
        }
        return this.getContent().getVersion();
    }

    public final ContentTypeVersioned getContentType() {
        if (this.type == null) {
            if (this.files.containsKey("mimetype")) {
                this.type = ContentTypeVersioned.fromMime(new String(this.getBinaryFile("mimetype")));
            } else if (this.getVersion().equals("OpenOffice.org")) {
                Element contentRoot = this.getContent().getDocument().getRootElement();
                String docClass = contentRoot.getAttributeValue("class", contentRoot.getNamespace("office"));
                this.type = ContentTypeVersioned.fromClass(docClass);
            } else if (this.getVersion().equals("OpenDocument")) {
                Element bodyChild = (Element)this.getContent().getChild("body").getChildren().get(0);
                this.type = ContentTypeVersioned.fromBody(bodyChild.getName());
            }
        }
        return this.type;
    }

    public final String getMimeType() {
        return this.getContentType().getMimeType();
    }

    public final Set<String> getEntries() {
        return this.files.keySet();
    }

    public final ODPackageEntry getEntry(String entry) {
        return this.files.get(entry);
    }

    protected final Object getData(String entry) {
        ODPackageEntry e = this.getEntry(entry);
        return e == null ? null : e.getData();
    }

    public final byte[] getBinaryFile(String entry) {
        return (byte[])this.getData(entry);
    }

    public final ODXMLDocument getXMLFile(String xmlEntry) {
        return (ODXMLDocument)this.getData(xmlEntry);
    }

    public final ODXMLDocument getContent() {
        return this.getXMLFile("content.xml");
    }

    public Document getDocument(String xmlEntry) {
        return this.getXMLFile(xmlEntry).getDocument();
    }

    public void putFile(String entry, Object data) {
        this.putFile(entry, data, null);
    }

    public void putFile(String entry, Object data, String mediaType) {
        Object myData;
        if (entry == null) {
            throw new NullPointerException("null name");
        }
        if (subdocNames.contains(entry)) {
            ODXMLDocument oodoc = data instanceof Document ? new ODXMLDocument((Document)data) : (ODXMLDocument)data;
            if (this.getVersion() != null && !oodoc.getVersion().equals(this.getVersion())) {
                throw new IllegalArgumentException("version mismatch " + this.getVersion() + " != " + oodoc);
            }
            myData = oodoc;
        } else {
            if (data != null && !(data instanceof byte[])) {
                throw new IllegalArgumentException("should be byte[] for " + entry + ": " + data);
            }
            myData = data;
        }
        String inferredType = mediaType != null ? mediaType : FileUtils.findMimeType(entry);
        this.files.put(entry, new ODPackageEntry(entry, inferredType, myData));
    }

    public void rmFile(String entry) {
        this.files.remove(entry);
    }

    public ODSingleXMLDocument toSingle() {
        Document content = this.removeAndGetDoc("content.xml");
        Document styles = this.removeAndGetDoc("styles.xml");
        Document settings = this.removeAndGetDoc("settings.xml");
        return ODSingleXMLDocument.createFromDocument(content, styles, settings, this);
    }

    private Document removeAndGetDoc(String name) {
        if (!this.files.containsKey(name)) {
            return null;
        }
        ODXMLDocument xmlDoc = (ODXMLDocument)this.files.remove(name).getData();
        return xmlDoc == null ? null : xmlDoc.getDocument();
    }

    public final void save(OutputStream out) throws IOException {
        Zip z = new Zip(out);
        z.zipNonCompressed("mimetype", this.getMimeType().getBytes("UTF8"));
        Manifest manifest = new Manifest(this.getVersion(), this.getMimeType());
        for (String name : this.files.keySet()) {
            String mediaType;
            if (name.equals("mimetype") || name.equals("META-INF/manifest.xml")) continue;
            ODPackageEntry entry = this.files.get(name);
            Object val = entry.getData();
            if (val != null) {
                OutputStream o = z.createEntry(name);
                if (val instanceof ODXMLDocument) {
                    OUTPUTTER.output(((ODXMLDocument)val).getDocument(), o);
                } else {
                    StreamUtils.copy(new ByteArrayInputStream((byte[])val), o);
                }
                o.close();
            }
            manifest.addEntry(name, (mediaType = entry.getType()) == null ? "" : mediaType);
        }
        z.zip("META-INF/manifest.xml", new StringInputStream(manifest.asString()));
        z.close();
    }

    public File save() throws IOException {
        return this.saveAs(this.getFile());
    }

    public File saveAs(File fNoExt) throws IOException {
        File f = this.addExt(fNoExt);
        if (f.getParentFile() != null) {
            f.getParentFile().mkdirs();
        }
        FileOutputStream out = new FileOutputStream(f);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(out, 524288);
        try {
            this.save(bufferedOutputStream);
        }
        finally {
            bufferedOutputStream.close();
        }
        return f;
    }
}

