/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jopendocument.dom.spreadsheet.BytesProducer;
import org.jopendocument.dom.spreadsheet.Cell;
import org.jopendocument.dom.spreadsheet.Row;
import org.jopendocument.util.FileUtils;

public class MutableCell
extends Cell {
    private static final DateFormat TextPDateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private static final NumberFormat TextPFloatFormat = new DecimalFormat(",##0.00");

    MutableCell(Row parent, Element elem) {
        super(parent, elem);
    }

    private void setType(String type) {
        if (type == null) {
            this.getElement().removeAttribute("value-type", this.getValueNS());
        } else {
            this.getElement().setAttribute("value-type", type, this.getValueNS());
        }
    }

    private void setValueAttribute(String value) {
        if (value == null) {
            this.getElement().removeAttribute("value", this.getValueNS());
            this.getElement().removeAttribute("date-value", this.getValueNS());
        } else {
            String attr = this.getType().equals("date") ? "date-value" : "value";
            this.getElement().setAttribute(attr, value, this.getValueNS());
        }
    }

    private void setTextP(String value) {
        Element t = new Element("p", this.getNS().getTEXT());
        t.addContent(value);
        this.getElement().setContent(t);
    }

    public void clearValue() {
        this.setValueAttribute(null);
        this.setType(null);
        this.getElement().removeContent();
    }

    public void setValue(Object obj) {
        if (obj instanceof Number) {
            this.setValue(obj.toString(), "float", TextPFloatFormat.format(obj));
        } else if (obj instanceof Date) {
            this.setValue(OODateFormat.format(obj), "date", TextPDateFormat.format(obj));
        } else {
            this.setValue(null, null, obj.toString());
        }
    }

    public void replaceBy(String oldValue, String newValue) {
        this.replaceContentBy(this.getElement(), oldValue, newValue);
    }

    private void replaceContentBy(Element l, String oldValue, String newValue) {
        List content = l.getContent();
        int i = 0;
        while (i < content.size()) {
            Object obj = content.get(i);
            if (obj instanceof Text) {
                Text t = (Text)obj;
                t.setText(t.getText().replaceAll(oldValue, newValue));
            } else if (obj instanceof Element) {
                this.replaceContentBy((Element)obj, oldValue, newValue);
            }
            ++i;
        }
    }

    private void setValue(String value, String type, String textP) {
        this.setType(type);
        this.setValueAttribute(value);
        this.setTextP(textP);
    }

    public void setStyle(String style) {
        this.getElement().setAttribute("style-name", style, this.getNS().getTABLE());
    }

    public void setImage(File pic) throws IOException {
        this.setImage(pic, false);
    }

    public void setImage(File pic, boolean keepRatio) throws IOException {
        this.setImage(pic.getName(), new BytesProducer.ByteArrayProducer(FileUtils.readBytes(pic), keepRatio));
    }

    public void setImage(String name, Image img) throws IOException {
        this.setImage(name, img == null ? null : new BytesProducer.ImageProducer(img, true));
    }

    private void setImage(String name, BytesProducer data) {
        Element imageElem;
        Namespace draw = this.getNS().getNS("draw");
        Element frame = this.getElement().getChild("frame", draw);
        Element element = imageElem = frame == null ? null : frame.getChild("image", draw);
        if (imageElem != null) {
            Attribute refAttr = imageElem.getAttribute("href", this.getNS().getNS("xlink"));
            this.parent.getSheet().getSpreadSheet().putFile(refAttr.getValue(), null);
            if (data == null) {
                frame.detach();
            } else {
                refAttr.setValue("Pictures/" + name + (data.getFormat() != null ? "." + data.getFormat() : ""));
                this.parent.getSheet().getSpreadSheet().putFile(refAttr.getValue(), data.getBytes(frame));
            }
        } else if (data != null) {
            throw new IllegalStateException("this cell doesn't contain an image: " + this);
        }
    }
}

