/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.awt.Point;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import junit.framework.TestCase;
import org.jopendocument.dom.NS;
import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.SpreadSheet;

public class SheetTest
extends TestCase {
    static final DefaultTableModel tm = new DefaultTableModel();
    private Sheet sheet;

    static {
        tm.addColumn("col1");
        tm.addColumn("col2");
        tm.addColumn("col3");
        tm.addRow(new Object[]{"un1", new Float(-5.32), new Integer(123)});
    }

    protected void setUp() throws Exception {
        this.sheet = SpreadSheet.createEmpty(tm, NS.getOOo()).getSheet(0);
    }

    protected void tearDown() throws Exception {
        this.sheet = null;
    }

    public void testSetValueAt() {
        SheetTest.assertEquals((Object)"col1", (Object)this.sheet.getValueAt(0, 0));
        this.sheet.setValueAt("test", 0, 0);
        SheetTest.assertEquals((Object)"test", (Object)this.sheet.getValueAt(0, 0));
    }

    public void testGetImmutableCellAtIntInt() {
    }

    public void testGetImmutableCellAtString() {
    }

    public void testGetValueAtIntInt() {
        SheetTest.assertEquals((Object)new Float(123.0f), (Object)this.sheet.getValueAt(2, 1));
    }

    public void testGetValueAtString() {
        SheetTest.assertEquals((Object)new Float(123.0f), (Object)this.sheet.getValueAt("C2"));
        SheetTest.assertFalse((boolean)new Integer(123).equals(this.sheet.getValueAt("C2")));
    }

    public void testGetRowCount() {
        SheetTest.assertEquals((int)2, (int)this.sheet.getRowCount());
    }

    public void testGetColumnCount() {
        SheetTest.assertEquals((int)3, (int)this.sheet.getColumnCount());
    }

    public void testSetColumnCountInt() {
        int newSize = this.sheet.getColumnCount() + 5;
        try {
            this.sheet.setValueAt("test", newSize - 1, 0);
            SheetTest.fail((String)"should have thrown IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.sheet.setColumnCount(newSize);
        this.sheet.setValueAt("test", newSize - 1, 0);
    }

    public void testEnsureColumnCount() {
        int before = this.sheet.getColumnCount();
        int newSize = before - 2;
        this.sheet.ensureColumnCount(newSize);
        SheetTest.assertEquals((int)before, (int)this.sheet.getColumnCount());
    }

    public void testSetColumnCountIntInt() {
    }

    public void testEnsureRowCount() {
    }

    public void testSetRowCountInt() {
    }

    public void testSetRowCountIntInt() {
    }

    public void testGetTableModel() {
        TableModel t = this.sheet.getTableModel(1, 0);
        SheetTest.assertEquals((int)(tm.getColumnCount() - 1), (int)t.getColumnCount());
        SheetTest.assertEquals((int)(tm.getRowCount() + 1), (int)t.getRowCount());
        SheetTest.assertEquals((Object)new Float(-5.32), (Object)t.getValueAt(1, 0));
    }

    public void testGetMutableTableModel() {
        this.sheet.getMutableTableModel(1, 0).setValueAt("test", 0, 1);
        SheetTest.assertEquals((Object)"test", (Object)this.sheet.getCellAt("C1").getValue());
    }

    public void testMerge() {
    }

    public void testIsCellRef() {
        SheetTest.assertTrue((boolean)Sheet.isCellRef("A23"));
        SheetTest.assertFalse((boolean)Sheet.isCellRef("A23A"));
        SheetTest.assertFalse((boolean)Sheet.isCellRef("test"));
        SheetTest.assertFalse((boolean)Sheet.isCellRef("23"));
    }

    public void testResolve() {
        SheetTest.assertEquals((Object)Sheet.resolve("AA34"), (Object)new Point(26, 33));
    }

    public void testToInt() {
        SheetTest.assertEquals((int)0, (int)Sheet.toInt("A"));
        SheetTest.assertEquals((int)26, (int)Sheet.toInt("AA"));
        SheetTest.assertEquals((int)77, (int)Sheet.toInt("BZ"));
    }
}

