/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.io;

import java.util.Stack;
import org.jopendocument.model.office.OfficeAutomaticStyles;
import org.jopendocument.model.office.OfficeMasterStyles;
import org.jopendocument.model.office.OfficeStyles;
import org.jopendocument.model.style.StyleDefaultStyle;
import org.jopendocument.model.style.StyleMasterPage;
import org.jopendocument.model.style.StylePageLayout;
import org.jopendocument.model.style.StylePageLayoutProperties;
import org.jopendocument.model.style.StyleTextProperties;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SaxStylesUnmarshaller
extends DefaultHandler {
    private OfficeStyles styles = new OfficeStyles();
    private OfficeAutomaticStyles autoStyles = new OfficeAutomaticStyles();
    private OfficeMasterStyles masterStyles = new OfficeMasterStyles();
    private Stack<Object> stack = new Stack();
    private Object current;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attribs) {
        if (qName.equals("office:styles")) {
            this.styles = new OfficeStyles();
            this.push(this.styles);
        } else if (qName.equals("style:default-style")) {
            StyleDefaultStyle defaultStyle = new StyleDefaultStyle();
            defaultStyle.setStyleFamily(attribs.getValue("style:family"));
            if (this.current instanceof OfficeStyles) {
                ((OfficeStyles)this.current).addDefaultStyle(defaultStyle);
            } else {
                System.err.println("Not OfficeStyles:" + this.current);
            }
            this.push(defaultStyle);
        } else if (qName.equals("style:text-properties")) {
            StyleTextProperties props = new StyleTextProperties();
            props.setFontName(attribs.getValue("style:font-name"));
            if (this.current instanceof StyleDefaultStyle) {
                ((StyleDefaultStyle)this.current).setStyleTextProperties(props);
            } else {
                System.err.println("Not StyleDefaultStyle:" + this.current);
            }
            this.push(props);
        } else if (qName.equals("office:automatic-styles")) {
            this.autoStyles = new OfficeAutomaticStyles();
            this.push(this.autoStyles);
        } else if (qName.equals("style:page-layout")) {
            StylePageLayout layout = new StylePageLayout();
            layout.setStyleName(attribs.getValue("style:name"));
            if (this.current instanceof OfficeAutomaticStyles) {
                this.autoStyles.addPageLayout(layout);
            } else {
                System.err.println("Not OfficeAutomaticStyles:" + this.current);
            }
            this.push(layout);
        } else if (qName.equals("style:page-layout-properties")) {
            StylePageLayoutProperties props = new StylePageLayoutProperties();
            props.setPageWidth(attribs.getValue("fo:page-width"));
            props.setPageHeight(attribs.getValue("fo:page-height"));
            props.setMarginTop(attribs.getValue("fo:margin-top"));
            props.setMarginBottom(attribs.getValue("fo:margin-bottom"));
            props.setMarginLeft(attribs.getValue("fo:margin-left"));
            props.setMarginRight(attribs.getValue("fo:margin-right"));
            props.setShadow(attribs.getValue("style:shadow"));
            props.setBackgroundColor(attribs.getValue("fo:background-color"));
            props.setScaleTo(attribs.getValue("style:scale-to"));
            props.setTableCentering(attribs.getValue("style:table-centering"));
            props.setWritingMode(attribs.getValue("style:writing-mode"));
            if (this.current instanceof StylePageLayout) {
                ((StylePageLayout)this.current).setPageLayoutProperties(props);
            } else {
                System.err.println("Not StylePageLayout:" + this.current);
            }
            this.push(props);
        } else if (qName.equals("office:master-styles")) {
            this.masterStyles = new OfficeMasterStyles();
            this.push(this.masterStyles);
        } else if (qName.equals("style:master-page")) {
            StyleMasterPage page = new StyleMasterPage();
            page.setStyleName(attribs.getValue("style:name"));
            page.setStylePageLayoutName(attribs.getValue("style:page-layout-name"));
            if (this.current instanceof OfficeMasterStyles) {
                this.masterStyles.addMasterPage(page);
            } else {
                System.err.println("Not OfficeMasterStyles:" + this.current);
            }
            this.push(page);
        } else {
            System.err.println("style.xml : ignoring :" + qName);
            this.push(uri);
        }
    }

    private void push(Object o) {
        this.current = o;
        this.stack.push(o);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.pop();
    }

    private void pop() {
        if (!this.stack.isEmpty()) {
            this.stack.pop();
        }
        if (!this.stack.isEmpty()) {
            this.current = this.stack.peek();
        }
    }

    @Override
    public void characters(char[] data, int start, int length) {
    }

    public OfficeStyles getStyles() {
        return this.styles;
    }

    public OfficeMasterStyles getMasterStyles() {
        return this.masterStyles;
    }

    public OfficeAutomaticStyles getAutomaticStyles() {
        return this.autoStyles;
    }
}

