/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.model.table;

import java.util.List;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.jopendocument.model.draw.DrawFrame;
import org.jopendocument.model.draw.DrawImage;
import org.jopendocument.model.office.OfficeAnnotation;
import org.jopendocument.model.style.StyleStyle;
import org.jopendocument.model.table.TableCellRangeSource;
import org.jopendocument.model.table.TableDetective;
import org.jopendocument.model.table.TableTableColumn;
import org.jopendocument.model.table.TableTableRow;
import org.jopendocument.model.text.TextP;

public class TableTableCell {
    @XmlAttribute(name="table:number-columns-repeated")
    protected int tableNumberColumnsRepeated = 1;
    @XmlAttribute(name="table:number-rows-spanned")
    protected int tableNumberRowsSpanned = 1;
    @XmlAttribute(name="table:number-columns-spanned")
    protected int tableNumberColumnsSpanned = 1;
    @XmlAttribute(name="table:style-name")
    protected String tableStyleName;
    @XmlAttribute(name="table:validation-name")
    protected String tableValidationName;
    @XmlAttribute(name="table:formula")
    protected String tableFormula;
    @XmlAttribute(name="table:number-matrix-rows-spanned")
    protected String tableNumberMatrixRowsSpanned;
    @XmlAttribute(name="table:number-matrix-columns-spanned")
    protected String tableNumberMatrixColumnsSpanned;
    @XmlAttribute(name="table:value-type")
    protected String tableValueType;
    @XmlAttribute(name="table:value")
    protected String tableValue;
    @XmlAttribute(name="table:date-value")
    protected String tableDateValue;
    @XmlAttribute(name="table:time-value")
    protected String tableTimeValue;
    @XmlAttribute(name="table:boolean-value")
    protected String tableBooleanValue;
    @XmlAttribute(name="table:string-value")
    protected String tableStringValue;
    @XmlAttribute(name="table:currency")
    protected String tableCurrency;
    @XmlAttribute(name="table:protected")
    protected String tableProtected;
    @XmlElement(name="table:cell-range-source")
    protected TableCellRangeSource tableCellRangeSource;
    @XmlElement(name="table:detective")
    protected TableDetective tableDetective;
    @XmlElement(name="office:annotation")
    protected OfficeAnnotation officeAnnotation;
    private TextP textP;
    protected TableTableRow row;
    private TableTableColumn column;
    private boolean covered;
    private DrawImage drawImage;
    private List<DrawFrame> drawFrames;
    private StyleStyle cellStyle;

    public int getTableNumberColumnsRepeated() {
        return this.tableNumberColumnsRepeated;
    }

    public void setTableNumberColumnsRepeated(String value) {
        if (value != null) {
            this.tableNumberColumnsRepeated = Integer.valueOf(value);
        }
    }

    public int getTableNumberRowsSpanned() {
        return this.tableNumberRowsSpanned;
    }

    public void setTableNumberRowsSpanned(String value) {
        if (value != null) {
            this.tableNumberRowsSpanned = Integer.valueOf(value);
        }
    }

    public int getTableNumberColumnsSpanned() {
        return this.tableNumberColumnsSpanned;
    }

    public void setTableNumberColumnsSpanned(String value) {
        if (value != null) {
            this.tableNumberColumnsSpanned = Integer.valueOf(value);
        }
    }

    public String getStyleName() {
        return this.tableStyleName;
    }

    public void setTableStyleName(String value) {
        this.tableStyleName = value;
        this.computeStyle();
    }

    public String getTableValidationName() {
        return this.tableValidationName;
    }

    public void setTableValidationName(String value) {
        this.tableValidationName = value;
    }

    public String getTableFormula() {
        return this.tableFormula;
    }

    public void setTableFormula(String value) {
        this.tableFormula = value;
    }

    public String getTableNumberMatrixRowsSpanned() {
        return this.tableNumberMatrixRowsSpanned;
    }

    public void setTableNumberMatrixRowsSpanned(String value) {
        this.tableNumberMatrixRowsSpanned = value;
    }

    public String getTableNumberMatrixColumnsSpanned() {
        return this.tableNumberMatrixColumnsSpanned;
    }

    public void setTableNumberMatrixColumnsSpanned(String value) {
        this.tableNumberMatrixColumnsSpanned = value;
    }

    public String getTableValueType() {
        if (this.tableValueType == null) {
            return "string";
        }
        return this.tableValueType;
    }

    public void setTableValueType(String value) {
        this.tableValueType = value;
    }

    public String getTableValue() {
        return this.tableValue;
    }

    public void setTableValue(String value) {
        this.tableValue = value;
    }

    public String getTableDateValue() {
        return this.tableDateValue;
    }

    public void setTableDateValue(String value) {
        this.tableDateValue = value;
    }

    public String getTableTimeValue() {
        return this.tableTimeValue;
    }

    public void setTableTimeValue(String value) {
        this.tableTimeValue = value;
    }

    public String getTableBooleanValue() {
        return this.tableBooleanValue;
    }

    public void setTableBooleanValue(String value) {
        this.tableBooleanValue = value;
    }

    public String getTableStringValue() {
        return this.tableStringValue;
    }

    public void setTableStringValue(String value) {
        this.tableStringValue = value;
    }

    public String getTableCurrency() {
        return this.tableCurrency;
    }

    public void setTableCurrency(String value) {
        this.tableCurrency = value;
    }

    public String getTableProtected() {
        if (this.tableProtected == null) {
            return "false";
        }
        return this.tableProtected;
    }

    public void setTableProtected(String value) {
        this.tableProtected = value;
    }

    public TableCellRangeSource getTableCellRangeSource() {
        return this.tableCellRangeSource;
    }

    public void setTableCellRangeSource(TableCellRangeSource value) {
        this.tableCellRangeSource = value;
    }

    public OfficeAnnotation getOfficeAnnotation() {
        return this.officeAnnotation;
    }

    public void setOfficeAnnotation(OfficeAnnotation value) {
        this.officeAnnotation = value;
    }

    public TableDetective getTableDetective() {
        return this.tableDetective;
    }

    public void setTableDetective(TableDetective value) {
        this.tableDetective = value;
    }

    public void setTextP(TextP p) {
        if (this.textP != null) {
            System.err.println("TableTableCell: Warning: no support for multiple TextP in a Cell");
        } else {
            this.textP = p;
        }
    }

    public TextP getTextP() {
        return this.textP;
    }

    public String toString() {
        return "Cell: style:" + this.getStyleName() + " TestP:" + this.getTextP();
    }

    public void setRowAndColumn(TableTableRow r, TableTableColumn c) {
        this.row = r;
        this.column = c;
        this.computeStyle();
    }

    public StyleStyle getStyle() {
        return this.cellStyle;
    }

    private void computeStyle() {
        if (this.column == null) {
            return;
        }
        String styleName = this.getStyleName();
        if (styleName == null) {
            styleName = this.column.getTableDefaultCellStyleName();
        }
        this.cellStyle = this.row.getTable().getCellStyle(styleName);
        if (this.cellStyle == null) {
            System.err.println(String.valueOf(styleName) + " not found");
            Thread.dumpStack();
        }
    }

    public void setCovered(boolean b) {
        this.covered = b;
    }

    public boolean isCovered() {
        return this.covered;
    }

    public void addDrawFrame(DrawFrame p) {
        if (this.drawFrames == null) {
            this.drawFrames = new Vector<DrawFrame>();
        }
        this.drawFrames.add(p);
    }

    public List<DrawFrame> getDrawFrames() {
        return this.drawFrames;
    }

    protected TableTableCell cloneCell() {
        TableTableCell c = new TableTableCell();
        c.tableNumberColumnsRepeated = this.tableNumberColumnsRepeated;
        c.tableNumberRowsSpanned = this.tableNumberRowsSpanned;
        c.tableNumberColumnsSpanned = this.tableNumberColumnsSpanned;
        c.tableStyleName = this.tableStyleName;
        c.tableValidationName = this.tableValidationName;
        c.tableFormula = this.tableFormula;
        c.tableNumberMatrixRowsSpanned = this.tableNumberMatrixRowsSpanned;
        c.tableNumberMatrixColumnsSpanned = this.tableNumberMatrixColumnsSpanned;
        c.tableValueType = this.tableValueType;
        c.tableValue = this.tableValue;
        c.tableDateValue = this.tableDateValue;
        c.tableTimeValue = this.tableTimeValue;
        c.tableBooleanValue = this.tableBooleanValue;
        c.tableStringValue = this.tableStringValue;
        c.tableCurrency = this.tableCurrency;
        c.tableProtected = this.tableProtected;
        c.tableCellRangeSource = this.tableCellRangeSource;
        c.tableDetective = this.tableDetective;
        c.officeAnnotation = this.officeAnnotation;
        c.textP = this.textP;
        c.covered = this.covered;
        c.drawImage = this.drawImage;
        c.drawFrames = this.drawFrames;
        return c;
    }

    public TableTableRow getRow() {
        return this.row;
    }
}

