/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.model.table;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.jopendocument.model.style.StyleStyle;
import org.jopendocument.model.table.TableTable;

@XmlRootElement(name="table:table-column")
public class TableTableColumn {
    @XmlAttribute(name="table:number-columns-repeated")
    protected String tableNumberColumnsRepeated;
    @XmlAttribute(name="table:style-name")
    protected String tableStyleName;
    @XmlAttribute(name="table:visibility")
    protected String tableVisibility;
    @XmlAttribute(name="table:default-cell-style-name")
    protected String tableDefaultCellStyleName;
    private TableTable table;

    public int getTableNumberColumnsRepeated() {
        if (this.tableNumberColumnsRepeated == null) {
            return 1;
        }
        return Integer.valueOf(this.tableNumberColumnsRepeated);
    }

    public void setTableNumberColumnsRepeated(String value) {
        this.tableNumberColumnsRepeated = value;
    }

    public String getTableStyleName() {
        return this.tableStyleName;
    }

    public void setTableStyleName(String value) {
        this.tableStyleName = value;
    }

    public String getTableVisibility() {
        if (this.tableVisibility == null) {
            return "visible";
        }
        return this.tableVisibility;
    }

    public void setTableVisibility(String value) {
        this.tableVisibility = value;
    }

    public String getTableDefaultCellStyleName() {
        return this.tableDefaultCellStyleName;
    }

    public void setTableDefaultCellStyleName(String value) {
        this.tableDefaultCellStyleName = value;
    }

    public int getWidth() {
        if (this.getTableStyleName() == null) {
            return 25000;
        }
        StyleStyle s = this.table.getSpreadsheet().getBody().getDocument().getAutomaticStyles().getColumnStyle(this.getTableStyleName());
        return s.getStyleTableColumnProperties().getColumnWidth();
    }

    public void setTable(TableTable t) {
        this.table = t;
    }

    public StyleStyle getDefaultCellStyle() {
        StyleStyle s = this.table.getCellStyle(this.tableDefaultCellStyleName);
        if (s == null) {
            throw new IllegalStateException("Unable to find cell style:'" + this.tableDefaultCellStyleName + "'");
        }
        return s;
    }

    public String toString() {
        return "TableColumn: style:" + this.getTableStyleName() + " defaultCellStyle:" + this.tableDefaultCellStyleName;
    }
}

