/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.print;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.RepaintManager;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.renderer.ODTRenderer;

public class ODTPrinter
implements Printable {
    protected ODTRenderer renderer;

    public ODTPrinter(OpenDocument doc) {
        this.renderer = new ODTRenderer(doc);
        this.renderer.setPaintMaxResolution(true);
    }

    public void print() {
        final PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                if (printJob.printDialog()) {
                    try {
                        printJob.print();
                    }
                    catch (PrinterException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        t.setName("ODTDPrinter Thread");
        t.setDaemon(true);
        t.start();
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= this.renderer.getPrintedPagesNumber()) {
            return 1;
        }
        RepaintManager currentManager = RepaintManager.currentManager(this.renderer);
        currentManager.setDoubleBufferingEnabled(false);
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        double maxPrintWidth = this.renderer.getPrintWidth();
        double pageWidth = pageFormat.getImageableWidth();
        double resize = maxPrintWidth / pageWidth;
        this.renderer.setIgnoreMargins(true);
        this.renderer.setResizeFactor(resize);
        this.renderer.setCurrentPage(pageIndex);
        this.renderer.paintComponent(g2d);
        return 0;
    }
}

