/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jopendocument.io.ODTContentExtractor;

public class ContentFinder
extends JFrame {
    private static final long serialVersionUID = -8535510980733968129L;
    private File selectedDir;
    final JTextField textFieldFolder = new JTextField(200);

    public ContentFinder() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)new JLabel("Explore folder:"), "West");
        p.add((Component)this.textFieldFolder, "Center");
        JButton buttonSelection = new JButton("Select folder");
        buttonSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContentFinder.this.openSelectionDialog();
            }
        });
        p.add((Component)buttonSelection, "East");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)new JLabel("Find text:"), "West");
        final JTextField textFieldRecherche = new JTextField(200);
        mainPanel.add((Component)textFieldRecherche, "Center");
        final JLabel status = new JLabel("");
        mainPanel.add((Component)status, "South");
        final JTextArea result = new JTextArea();
        result.setEditable(false);
        JScrollPane scroll = new JScrollPane(result);
        final JButton searchButton = new JButton("Find");
        searchButton.setEnabled(false);
        JPanel framePanel = new JPanel();
        framePanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        framePanel.add((Component)p, c);
        ++c.gridy;
        framePanel.add((Component)mainPanel, c);
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        framePanel.add((Component)scroll, c);
        ++c.gridy;
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 13;
        framePanel.add((Component)searchButton, c);
        this.setContentPane(framePanel);
        searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                searchButton.setEnabled(false);
                if (ContentFinder.this.selectedDir == null) {
                    ContentFinder.this.openSelectionDialog();
                }
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if (ContentFinder.this.selectedDir != null && ContentFinder.this.selectedDir.isDirectory()) {
                            File[] files = ContentFinder.this.selectedDir.listFiles();
                            result.setText("");
                            int i = 0;
                            while (i < files.length) {
                                File file = files[i];
                                String name = file.getName();
                                if (name.endsWith(".sxc") || name.endsWith(".sxc") || name.endsWith(".ods") || name.endsWith(".odt")) {
                                    this.updateStatus("Looking at:" + file.getAbsolutePath());
                                    ODTContentExtractor l = new ODTContentExtractor(file);
                                    try {
                                        l.load();
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                    if (l.containsIgnoreCase(textFieldRecherche.getText())) {
                                        result.append(String.valueOf(file.getAbsolutePath()) + "\n");
                                    }
                                }
                                this.updateStatus("Done");
                                ++i;
                            }
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                searchButton.setEnabled(true);
                            }
                        });
                    }

                    private void updateStatus(final String s) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                status.setText(s);
                            }
                        });
                    }
                };
                Thread th = new Thread(r);
                th.start();
            }
        });
        textFieldRecherche.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.checkDocument();
            }

            private void checkDocument() {
                if (textFieldRecherche.getText().trim().length() == 0) {
                    searchButton.setEnabled(false);
                } else {
                    searchButton.setEnabled(true);
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.checkDocument();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.checkDocument();
            }
        });
        this.textFieldFolder.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.checkDocument();
            }

            private void checkDocument() {
                String fNma = ContentFinder.this.textFieldFolder.getText().trim();
                File f = new File(fNma);
                if (f.exists() && f.isDirectory()) {
                    ContentFinder.this.selectedDir = f;
                    ContentFinder.this.textFieldFolder.setBackground(Color.WHITE);
                } else {
                    ContentFinder.this.textFieldFolder.setBackground(new Color(255, 220, 110));
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.checkDocument();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.checkDocument();
            }
        });
    }

    protected void openSelectionDialog() {
        File fi;
        JFileChooser fChooser = new JFileChooser();
        fChooser.setApproveButtonText("Look in folder...");
        fChooser.setFileSelectionMode(1);
        if (fChooser.showOpenDialog(this) == 0 && (fi = fChooser.getSelectedFile()) != null && fi.isDirectory()) {
            this.selectedDir = fi;
            this.textFieldFolder.setText(fi.getAbsolutePath());
        }
    }

    public static void main(String[] args) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        ContentFinder f = new ContentFinder();
        f.setDefaultCloseOperation(3);
        f.setSize(new Dimension(800, 400));
        f.setLocation(100, 100);
        f.setVisible(true);
    }
}

