/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jopendocument.util.CollectionUtils;
import org.jopendocument.util.RecursionType;
import org.jopendocument.util.cc.IClosure;

public final class FileUtils {
    private static final Map<String, String> ext2mime = new HashMap<String, String>();

    static {
        ext2mime.put(".xml", "text/xml");
        ext2mime.put(".jpg", "image/jpeg");
        ext2mime.put(".png", "image/png");
        ext2mime.put(".tiff", "image/tiff");
    }

    private FileUtils() {
    }

    public static List<String> listR(File dir) {
        return FileUtils.listR_rec(dir, ".");
    }

    private static List<String> listR_rec(File dir, String prefix) {
        if (!dir.isDirectory()) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        File[] children = dir.listFiles();
        int i = 0;
        while (i < children.length) {
            String newPrefix = String.valueOf(prefix) + "/" + children[i].getName();
            if (children[i].isFile()) {
                res.add(newPrefix);
            } else if (children[i].isDirectory()) {
                res.addAll(FileUtils.listR_rec(children[i], newPrefix));
            }
            ++i;
        }
        return res;
    }

    public static void walk(File dir, IClosure<File> c) {
        FileUtils.walk(dir, c, RecursionType.BREADTH_FIRST);
    }

    public static void walk(File dir, IClosure<File> c, RecursionType type) {
        if (type == RecursionType.BREADTH_FIRST) {
            c.execute(dir);
        }
        if (dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                FileUtils.walk(child, c, type);
                ++n2;
            }
        }
        if (type == RecursionType.DEPTH_FIRST) {
            c.execute(dir);
        }
    }

    public static final String relative(File fromDir, File to) throws IOException {
        if (!fromDir.isDirectory()) {
            throw new IllegalArgumentException(fromDir + " is not a directory");
        }
        File fromF = fromDir.getCanonicalFile();
        File toF = to.getCanonicalFile();
        List<File> toPath = FileUtils.getAncestors(toF);
        List<File> fromPath = FileUtils.getAncestors(fromF);
        if (!toPath.get(0).equals(fromPath.get(0))) {
            throw new IllegalArgumentException("'" + fromF + "' and '" + toF + "' have no common ancestor");
        }
        int commonIndex = Math.min(toPath.size(), fromPath.size()) - 1;
        boolean found = false;
        while (commonIndex >= 0 && !found) {
            found = fromPath.get(commonIndex).equals(toPath.get(commonIndex));
            if (found) continue;
            --commonIndex;
        }
        ArrayList<String> complete = new ArrayList<String>((Collection)Collections.nCopies(fromPath.size() - 1 - commonIndex, ".."));
        if (complete.isEmpty()) {
            complete.add(".");
        }
        for (File f : toPath.subList(commonIndex + 1, toPath.size())) {
            complete.add(f.getName());
        }
        return CollectionUtils.join(complete, File.separator);
    }

    private static List<File> getAncestors(File f) {
        ArrayList<File> path = new ArrayList<File>();
        File currentF = f;
        while (currentF != null) {
            path.add(0, currentF);
            currentF = currentF.getParentFile();
        }
        return path;
    }

    public static void mv(File f, File dest) {
        if (dest.isDirectory()) {
            f.renameTo(new File(dest, f.getName()));
        } else {
            f.renameTo(dest);
        }
    }

    public static void copyFile(File in, File out) throws IOException {
        FileChannel sourceChannel = new FileInputStream(in).getChannel();
        FileChannel destinationChannel = new FileOutputStream(out).getChannel();
        sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
        sourceChannel.close();
        destinationChannel.close();
    }

    public static void copyDirectory(File in, File out) throws IOException {
        if (in.isDirectory()) {
            if (!out.exists()) {
                out.mkdir();
            }
            String[] children = in.list();
            int i = 0;
            while (i < children.length) {
                FileUtils.copyDirectory(new File(in, children[i]), new File(out, children[i]));
                ++i;
            }
        } else if (!in.getName().equals("Thumbs.db")) {
            FileUtils.copyFile(in, out);
        }
    }

    public static boolean rmR(File dir) {
        if (dir.isDirectory()) {
            File[] children = dir.listFiles();
            int i = 0;
            while (i < children.length) {
                boolean success = FileUtils.rmR(children[i]);
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static final void mkdir_p(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("cannot create directory " + dir);
        }
    }

    public static final String read(File f) throws IOException {
        return FileUtils.read(f, null);
    }

    public static final String read(File f, String charset) throws IOException {
        return FileUtils.read(new FileInputStream(f), charset);
    }

    public static final String read(InputStream ins, String charset) throws IOException {
        InputStreamReader reader = charset == null ? new InputStreamReader(ins) : new InputStreamReader(ins, charset);
        return FileUtils.read(reader);
    }

    public static final String read(Reader reader) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(reader);
        String res = "";
        while ((line = in.readLine()) != null) {
            res = String.valueOf(res) + line + "\n";
        }
        in.close();
        return res;
    }

    public static final byte[] readBytes(File f) throws IOException {
        FileInputStream in = new FileInputStream(f);
        if (f.length() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("file longer than Integer.MAX_VALUE" + f.length());
        }
        byte[] res = new byte[(int)f.length()];
        ((InputStream)in).read(res);
        ((InputStream)in).close();
        return res;
    }

    public static void write(String s, File f) throws IOException {
        FileUtils.write(s, f, false);
    }

    public static void write(String s, File f, boolean append) throws IOException {
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(f, append)));
        try {
            w.write(s);
        }
        finally {
            w.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final void open(File f, String[] executables) throws IOException {
        block5: {
            try {
                FileUtils.openNative(f);
                break block5;
            }
            catch (IOException exn) {
                i = 0;
                ** while (i < executables.length)
            }
lbl-1000:
            // 1 sources

            {
                executable = executables[i];
                try {
                    Runtime.getRuntime().exec(new String[]{executable, f.getCanonicalPath()});
                    return;
                }
                catch (IOException var5_5) {
                    ++i;
                }
                continue;
            }
lbl15:
            // 1 sources

            throw new IOException("unable to open " + f + " with: " + Arrays.asList(executables));
        }
    }

    private static final void openNative(File f) throws IOException {
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            Runtime.getRuntime().exec(new String[]{"cmd", "/c", "start", "\"\"", f.getCanonicalPath()});
        } else if (os.startsWith("Mac OS")) {
            Runtime.getRuntime().exec(new String[]{"open", f.getCanonicalPath()});
        } else if (os.startsWith("Linux") && FileUtils.gnomeRunning()) {
            Runtime.getRuntime().exec(new String[]{"gnome-open", f.getCanonicalPath()});
        } else {
            throw new IOException("unknown way to open " + f);
        }
    }

    private static final boolean gnomeRunning() {
        try {
            return Runtime.getRuntime().exec(new String[]{"pgrep", "-u", System.getProperty("user.name"), "nautilus"}).waitFor() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static final String findMimeType(String fname) {
        for (Map.Entry<String, String> e : ext2mime.entrySet()) {
            if (!fname.toLowerCase().endsWith(e.getKey())) continue;
            return e.getValue();
        }
        return null;
    }
}

