/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jopendocument.dom.ContentTypeVersioned;
import org.jopendocument.dom.Manifest;
import org.jopendocument.dom.OOSingleXMLDocument;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.dom.OOXMLDocument;
import org.jopendocument.util.CopyUtils;
import org.jopendocument.util.ExceptionUtils;
import org.jopendocument.util.StreamUtils;
import org.jopendocument.util.StringInputStream;
import org.jopendocument.util.Zip;
import org.jopendocument.util.ZippedFilesProcessor;

public class ODPackage {
    private static final XMLOutputter OUTPUTTER = new XMLOutputter(Format.getRawFormat());
    private static final Set<String> subdocNames = new HashSet<String>();
    private final Map<String, Object> files = new HashMap<String, Object>();
    private ContentTypeVersioned type = null;

    static {
        subdocNames.add("content.xml");
        subdocNames.add("styles.xml");
        subdocNames.add("meta.xml");
        subdocNames.add("settings.xml");
    }

    private ODPackage() {
    }

    public ODPackage(Map<String, Object> files) {
        this();
        for (Map.Entry<String, Object> e : files.entrySet()) {
            this.putFile(e.getKey(), e.getValue());
        }
    }

    public ODPackage(InputStream ins) throws IOException {
        this();
        final ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        new ZippedFilesProcessor(){

            @Override
            protected void processEntry(String name, InputStream in) throws IOException {
                Object res;
                if (subdocNames.contains(name)) {
                    try {
                        res = new OOXMLDocument(OOUtils.getBuilder().build(in));
                    }
                    catch (JDOMException e) {
                        throw ExceptionUtils.createExn(IllegalStateException.class, "parse error", e);
                    }
                } else {
                    out.reset();
                    StreamUtils.copy(in, out);
                    res = out.toByteArray();
                }
                ODPackage.this.putFile(name, res);
            }
        }.process(ins);
    }

    public ODPackage(ODPackage o) {
        this();
        for (Map.Entry<String, Object> f : o.getFiles().entrySet()) {
            String name = f.getKey();
            Object data = f.getValue();
            if (data instanceof byte[]) {
                this.putFile(name, data);
                continue;
            }
            this.putFile(name, CopyUtils.copy(data));
        }
    }

    public final String getVersion() {
        if (this.getContent() == null) {
            return null;
        }
        return this.getContent().getVersion();
    }

    public final ContentTypeVersioned getContentType() {
        if (this.type == null) {
            if (this.files.containsKey("mimetype")) {
                this.type = ContentTypeVersioned.fromMime(new String(this.getBinaryFile("mimetype")));
            } else if (this.getVersion().equals("OpenOffice.org")) {
                Element contentRoot = this.getContent().getDocument().getRootElement();
                String docClass = contentRoot.getAttributeValue("class", contentRoot.getNamespace("office"));
                this.type = ContentTypeVersioned.fromClass(docClass);
            } else if (this.getVersion().equals("OpenDocument")) {
                Element bodyChild = (Element)this.getContent().getChild("body").getChildren().get(0);
                this.type = ContentTypeVersioned.fromBody(bodyChild.getName());
            }
        }
        return this.type;
    }

    public final String getMimeType() {
        return this.getContentType().getMimeType();
    }

    protected final Map<String, Object> getFiles() {
        return Collections.unmodifiableMap(this.files);
    }

    public byte[] getBinaryFile(String entry) {
        return (byte[])this.files.get(entry);
    }

    public OOXMLDocument getXMLFile(String xmlEntry) {
        return (OOXMLDocument)this.files.get(xmlEntry);
    }

    public final OOXMLDocument getContent() {
        return this.getXMLFile("content.xml");
    }

    public Document getDocument(String xmlEntry) {
        return this.getXMLFile(xmlEntry).getDocument();
    }

    public void putFile(String entry, Object data) {
        if (data == null) {
            this.files.remove(entry);
        } else {
            if (subdocNames.contains(entry)) {
                OOXMLDocument oodoc = data instanceof Document ? new OOXMLDocument((Document)data) : (OOXMLDocument)data;
                if (this.getVersion() != null && !oodoc.getVersion().equals(this.getVersion())) {
                    throw new IllegalArgumentException("version mismatch " + this.getVersion() + " != " + oodoc);
                }
                data = oodoc;
            } else if (!(data instanceof byte[])) {
                throw new IllegalArgumentException("should be byte[] " + data);
            }
            this.files.put(entry, data);
        }
    }

    public OOSingleXMLDocument toSingle() {
        Document content = this.removeAndGetDoc("content.xml");
        Document styles = this.removeAndGetDoc("styles.xml");
        Document settings = this.removeAndGetDoc("settings.xml");
        OOSingleXMLDocument single = OOSingleXMLDocument.createFromDocument(content, styles, settings, this.files);
        this.putFile("content.xml", single);
        return single;
    }

    private Document removeAndGetDoc(String name) {
        OOXMLDocument xmlDoc = (OOXMLDocument)this.files.remove(name);
        return xmlDoc == null ? null : xmlDoc.getDocument();
    }

    public final void save(OutputStream out) throws IOException {
        Zip z = new Zip(out);
        Manifest manifest = new Manifest(this.getVersion(), this.getMimeType());
        for (String name : this.files.keySet()) {
            if (name.equals("mimetype") || name.equals("META-INF/manifest.xml")) continue;
            Object val = this.files.get(name);
            OutputStream o = z.createEntry(name);
            if (val instanceof OOXMLDocument) {
                OUTPUTTER.output(((OOXMLDocument)val).getDocument(), o);
                manifest.addEntry(name, "text/xml");
            } else {
                StreamUtils.copy(new ByteArrayInputStream((byte[])val), o);
            }
            o.close();
        }
        z.zip("mimetype", new StringInputStream(this.getMimeType()));
        z.zip("META-INF/manifest.xml", new StringInputStream(manifest.asString()));
        z.close();
    }
}

