/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import org.jopendocument.dom.ODPackage;

public class OOFileDocument
extends ODPackage {
    private File file;

    public OOFileDocument(File f) throws IOException {
        super(new BufferedInputStream(new FileInputStream(f), 524288));
        this.file = f;
    }

    public OOFileDocument(Map<String, Object> files) {
        super(files);
        this.file = null;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File f) {
        String ext = String.valueOf('.') + this.getContentType().getExtension();
        if (!f.getName().endsWith(ext)) {
            f = new File(f.getParentFile(), String.valueOf(f.getName()) + ext);
        }
        this.file = f;
    }

    public File save() throws IOException {
        if (this.getFile().getParentFile() != null) {
            this.getFile().getParentFile().mkdirs();
        }
        FileOutputStream out = new FileOutputStream(this.getFile());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(out, 524288);
        this.save(bufferedOutputStream);
        bufferedOutputStream.close();
        return this.getFile();
    }
}

