/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.NS;
import org.jopendocument.util.FileUtils;
import org.jopendocument.util.JDOMUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class OOUtils {
    public static final String OOo = "OpenOffice.org";
    public static final String VERSION_1 = "OpenOffice.org";
    public static final String OD = "OpenDocument";
    public static final String VERSION_2 = "OpenDocument";
    private static final String[] executables = new String[]{"ooffice2", "ooffice", "soffice"};

    public static void open(File f) throws IOException {
        FileUtils.open(f, executables);
    }

    public static SAXBuilder getBuilder() {
        SAXBuilder builder = new SAXBuilder();
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                if (systemId.endsWith(".dtd")) {
                    InputSource in = new InputSource();
                    in.setCharacterStream(new StringReader(""));
                    return in;
                }
                return null;
            }
        });
        return builder;
    }

    public static SAXBuilder getBuilderLoadDTD() {
        SAXBuilder builder = new SAXBuilder(){

            @Override
            public Document build(InputSource in) throws JDOMException, IOException {
                in.setSystemId(OOUtils.class.getResource("oofficeDTDs/").toExternalForm());
                return super.build(in);
            }
        };
        return builder;
    }

    public static Document parseDocument(String doc) throws JDOMException {
        return JDOMUtils.parseStringDocument(doc, OOUtils.getBuilder());
    }

    public static final XPath getXPath(String path, String version) throws JDOMException {
        return OOUtils.getXPath(path, NS.get(version));
    }

    public static final XPath getXPath(String path, NS nss) throws JDOMException {
        XPath xp = XPath.newInstance(path);
        Namespace[] namespaceArray = nss.getALL();
        int n = namespaceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Namespace ns = namespaceArray[n2];
            xp.addNamespace(ns);
            ++n2;
        }
        return xp;
    }
}

