/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.model;

import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jopendocument.io.SaxContentUnmarshaller;
import org.jopendocument.io.SaxStylesUnmarshaller;
import org.jopendocument.model.PrintedPage;
import org.jopendocument.model.office.OfficeAutomaticStyles;
import org.jopendocument.model.office.OfficeBody;
import org.jopendocument.model.office.OfficeMasterStyles;
import org.jopendocument.model.office.OfficeSpreadsheet;
import org.jopendocument.model.office.OfficeStyles;
import org.jopendocument.model.style.StyleDefaultStyle;
import org.jopendocument.model.style.StylePageLayoutProperties;
import org.jopendocument.model.style.StyleStyle;
import org.jopendocument.model.table.TableTable;
import org.jopendocument.model.table.TableTableRow;
import org.jopendocument.util.ImageUtils;
import org.jopendocument.util.StreamUtils;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class OpenDocument {
    private static final int MAX_IN_MEMORY_HQ_IMAGE = 10;
    private OfficeAutomaticStyles autoStyles;
    private OfficeBody body;
    private final Map<String, Image> images = new HashMap<String, Image>();
    private final Map<String, Image> imagesHQ = new HashMap<String, Image>();
    private OfficeMasterStyles masterStyles;
    private List<PrintedPage> pages;
    private OfficeStyles styles;
    private ZipFile zipFile;

    public OpenDocument() {
    }

    public OpenDocument(File f) {
        this.loadFrom(f);
    }

    private void computePages() {
        this.pages = new ArrayList<PrintedPage>();
        List<OfficeSpreadsheet> l = this.body.getOfficeSpreadsheets();
        int currentHeight = 0;
        for (OfficeSpreadsheet sheet : l) {
            List<TableTable> tables = sheet.getTables();
            for (TableTable t : tables) {
                StylePageLayoutProperties pageLayoutProperties = t.getPageLayoutProperties();
                int pageHeight = 0;
                if (pageLayoutProperties != null) {
                    pageHeight = pageLayoutProperties.getPageHeight();
                }
                int printStartRow = t.getPrintStartRow();
                int printStopRow = t.getPrintStopRow();
                int printStartCol = t.getPrintStartCol();
                int printStopCol = t.getPrintStopCol();
                List<TableTableRow> rows = t.getRowsInRange(printStartRow, printStopRow);
                int splitRow = this.getSplitEveryRow(tables.indexOf(t));
                PrintedPage p = new PrintedPage();
                int j = 0;
                while (j < rows.size()) {
                    TableTableRow row = rows.get(j);
                    p.addRow(row);
                    if (splitRow > 0) {
                        if (j > 0 && (j + 1) % (splitRow + 1) == 0) {
                            this.pages.add(p);
                            p = new PrintedPage();
                        }
                    } else if ((currentHeight += row.getHeight()) > pageHeight) {
                        currentHeight = 0;
                        this.pages.add(p);
                        p = new PrintedPage();
                    }
                    ++j;
                }
                if (this.pages.contains(p) || p.isEmpty()) continue;
                this.pages.add(p);
            }
        }
    }

    public OfficeAutomaticStyles getAutomaticStyles() {
        return this.autoStyles;
    }

    public OfficeBody getBody() {
        return this.body;
    }

    public Image getImage(String xlinkHref) {
        Image i = this.images.get(xlinkHref);
        if (i != null) {
            return i;
        }
        ZipEntry entry = this.zipFile.getEntry(xlinkHref);
        byte[] bs = null;
        try {
            int count;
            InputStream stream = this.zipFile.getInputStream(entry);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int BUFFER_SIZE = 4096;
            byte[] buffer = new byte[4096];
            while ((count = stream.read(buffer, 0, 4096)) != -1) {
                out.write(buffer, 0, count);
            }
            out.close();
            bs = out.toByteArray();
            stream.read(bs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ImageIcon ic = new ImageIcon(bs);
        Image image = ic.getImage();
        if (ic.getImageLoadStatus() != 8) {
            throw new IllegalStateException("Unable to load:'" + xlinkHref + "'");
        }
        this.images.put(xlinkHref, image);
        return image;
    }

    public Image getImage(String xlinkHref, int width, int height) {
        String key = String.valueOf(width) + "," + height;
        Image im = this.imagesHQ.get(key);
        if (im != null) {
            return im;
        }
        im = ImageUtils.createQualityResizedImage(this.getImage(xlinkHref), width, height);
        if (this.imagesHQ.size() > 10) {
            this.imagesHQ.clear();
        }
        this.imagesHQ.put(key, im);
        return im;
    }

    public OfficeMasterStyles getMasterStyles() {
        return this.masterStyles;
    }

    public PrintedPage getPrintedPage(int i) {
        if (this.pages == null) {
            this.computePages();
        }
        return this.pages.get(i);
    }

    public int getPrintedPageCount() {
        return this.pages.size();
    }

    public int getSplitEveryRow(int indexOfSheet) {
        String path = String.valueOf(this.getZipFile().getName()) + "p";
        File f = new File(path);
        if (!f.exists()) {
            System.err.println("ODSP Not Exist");
            return -1;
        }
        SAXBuilder builder = new SAXBuilder();
        int row = -1;
        try {
            Document document = builder.build(f);
            Element root = document.getRootElement();
            Element splitrow = root.getChild("spliteveryrow");
            if (splitrow != null) {
                List l = splitrow.getChildren("sheet");
                for (Element element : l) {
                    String value;
                    int i;
                    String s = element.getAttributeValue("number");
                    if (s == null || s.trim().length() <= 0 || (i = Integer.valueOf(s).intValue()) != indexOfSheet || (value = element.getValue()) == null || value.trim().length() <= 0) continue;
                    row = Integer.valueOf(value);
                }
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return row;
    }

    public OfficeStyles getStyles() {
        return this.styles;
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    public void importAutoStylesFrom(OfficeAutomaticStyles stylesToAdd) {
        for (StyleStyle s : stylesToAdd.getStyles()) {
            this.autoStyles.addStyle(s);
        }
    }

    public void init(OfficeBody aBody, OfficeAutomaticStyles bodyAutoStyles, OfficeStyles s, OfficeAutomaticStyles auto, OfficeMasterStyles masters) {
        if (aBody == null) {
            throw new IllegalArgumentException("OfficeBody cannot be null");
        }
        if (bodyAutoStyles == null) {
            throw new IllegalArgumentException("OfficeAutomaticStyles cannot be null");
        }
        if (s == null) {
            throw new IllegalArgumentException("OfficeStyles cannot be null");
        }
        if (auto == null) {
            throw new IllegalArgumentException("OfficeAutomaticStyles cannot be null");
        }
        if (masters == null) {
            throw new IllegalArgumentException("OfficeMasterStyles cannot be null");
        }
        this.body = aBody;
        this.body.setDocument(this);
        this.styles = s;
        this.autoStyles = auto;
        this.importAutoStylesFrom(bodyAutoStyles);
        StyleDefaultStyle mainDefaultCellStyle = s.getDefaultCellStyle();
        if (mainDefaultCellStyle == null) {
            mainDefaultCellStyle = new StyleDefaultStyle();
            mainDefaultCellStyle.setStyleFamily("table-cell");
        }
        StyleStyle defaultCellStyle = new StyleStyle();
        defaultCellStyle.setStyleName("Default");
        defaultCellStyle.setTextProperties(mainDefaultCellStyle.getStyleTextProperties());
        defaultCellStyle.setStyleProperties(mainDefaultCellStyle.getStyleProperties());
        this.autoStyles.addStyle(defaultCellStyle);
        this.masterStyles = masters;
    }

    public void loadFrom(File f) {
        SaxContentUnmarshaller contentHandler = new SaxContentUnmarshaller(this);
        SaxStylesUnmarshaller stylesHandler = new SaxStylesUnmarshaller();
        try {
            this.zipFile = new ZipFile(f);
            XMLReader rdr = XMLReaderFactory.createXMLReader();
            rdr.setContentHandler(contentHandler);
            ZipEntry contnetEntry = this.zipFile.getEntry("content.xml");
            InputSource inputSource1 = new InputSource(new InputStreamReader(this.zipFile.getInputStream(contnetEntry), "UTF-8"));
            rdr.parse(inputSource1);
            rdr.setContentHandler(stylesHandler);
            ZipEntry stylesEntry = this.zipFile.getEntry("styles.xml");
            if (stylesEntry != null) {
                InputSource inputSource2 = new InputSource(new InputStreamReader(this.zipFile.getInputStream(stylesEntry), "UTF-8"));
                rdr.parse(inputSource2);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.init(contentHandler.getBody(), contentHandler.getAutomaticstyles(), stylesHandler.getStyles(), stylesHandler.getAutomaticStyles(), stylesHandler.getMasterStyles());
    }

    public void loadFrom(String fileName) {
        this.loadFrom(new File(fileName));
    }

    public void loadFrom(URL url) throws IOException {
        File file = File.createTempFile("jOpenDocument", ".ods");
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        StreamUtils.copy(url.openStream(), fileOutputStream);
        fileOutputStream.close();
        this.loadFrom(file);
    }

    public void preloadImage(String xlinkHref) {
        this.getImage(xlinkHref);
    }

    public void setAutomaticStyles(OfficeAutomaticStyles autostyles) {
        this.autoStyles = autostyles;
    }

    public void setMasterStyles(OfficeMasterStyles masterStyles) {
        this.masterStyles = masterStyles;
    }
}

