/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.print;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.RepaintManager;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.print.ODTPrinter;

public class ODTPrinterXML
extends ODTPrinter {
    File f;
    private static final boolean debug = false;

    public ODTPrinterXML(OpenDocument doc) {
        super(doc);
        String path = doc.getZipFile().getName();
        path = String.valueOf(path) + "p";
        this.f = new File(path);
        if (!this.f.exists()) {
            JOptionPane.showMessageDialog(null, String.valueOf(this.f.getAbsolutePath()) + " n'existe pas.");
            throw new IllegalStateException("Config file: " + path + " doesn't exist");
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= this.renderer.getPrintedPagesNumber()) {
            return 1;
        }
        RepaintManager currentManager = RepaintManager.currentManager(this.renderer);
        currentManager.setDoubleBufferingEnabled(false);
        Graphics2D g2d = (Graphics2D)g;
        int dx = 0;
        int dy = 0;
        boolean centerX = false;
        boolean centerY = false;
        double ratio = 1.0;
        SAXBuilder builder = new SAXBuilder();
        try {
            Element resize;
            Attribute ratioAttribute;
            Element center;
            Document document = builder.build(this.f);
            Element root = document.getRootElement();
            Element offset = root.getChild("offset");
            if (offset != null) {
                Attribute offsetYAttribute;
                Attribute offsetXAttribute = offset.getAttribute("x");
                if (offsetXAttribute != null) {
                    dx = offsetXAttribute.getIntValue();
                }
                if ((offsetYAttribute = offset.getAttribute("y")) != null) {
                    dy = offsetYAttribute.getIntValue();
                }
            }
            if ((center = root.getChild("center")) != null) {
                Attribute centerYAttribute;
                Attribute centerXAttribute = center.getAttribute("horizontal");
                if (centerXAttribute != null) {
                    centerX = centerXAttribute.getBooleanValue();
                }
                if ((centerYAttribute = center.getAttribute("vertical")) != null) {
                    centerY = centerYAttribute.getBooleanValue();
                }
            }
            if ((ratioAttribute = (resize = root.getChild("resize")).getAttribute("percent")) != null) {
                String s = ratioAttribute.getValue();
                ratio = Double.parseDouble(s = s.replace('%', ' ').trim()) / 100.0;
                if (ratio <= 0.0 || ratio > 1.0) {
                    throw new IllegalStateException("Ratio out of bound:" + s + "(should be > 0% and <= 100%");
                }
            }
            double maxPrintWidth = this.renderer.getPrintWidth();
            double pageWidth = pageFormat.getImageableWidth();
            double maxPrintHeight = this.renderer.getPrintHeight();
            double pageHeight = pageFormat.getImageableHeight();
            System.out.println("Ratio:" + ratio);
            double resizeDocument1 = maxPrintWidth / (pageWidth * ratio);
            this.renderer.setIgnoreMargins(true);
            System.err.println("resize factor " + resizeDocument1);
            this.renderer.setResizeFactor(resizeDocument1);
            if (centerX) {
                dx = (int)((double)dx + (pageWidth - (double)this.renderer.getPrintWidthInPixel()) / 2.0);
            }
            if (centerY) {
                dy = (int)((double)dy + (pageHeight - (double)this.renderer.getPrintHeightInPixel()) / 2.0);
            }
            g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            g2d.translate(dx, dy);
            this.renderer.setCurrentPage(pageIndex);
            this.renderer.paintComponent(g2d);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }
}

