/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import org.jopendocument.model.style.StyleParagraphProperties;
import org.jopendocument.model.style.StyleStyle;
import org.jopendocument.model.style.StyleTableCellProperties;
import org.jopendocument.model.table.TableTableCell;
import org.jopendocument.model.text.TextP;
import org.jopendocument.renderer.ODTCellRenderer;
import org.jopendocument.renderer.ODTCellText;
import org.jopendocument.util.ValueHelper;

public class ODTCellTextRenderer
implements ODTCellRenderer {
    @Override
    public void draw(Graphics2D g, int x, int y, int cellWidth, int cellHeight, double resizeFactor, TableTableCell cell, StyleTableCellProperties cellProps) {
        TextP textp = cell.getTextP();
        if (textp != null) {
            if (textp.isEmpty()) {
                return;
            }
            StyleStyle cellStyle = cell.getStyle();
            if (cellStyle == null) {
                g.setColor(Color.RED);
                g.drawRect(x, y, cellWidth, cellHeight);
                return;
            }
            ODTCellText text = new ODTCellText(g, textp, resizeFactor, cellStyle);
            if (!text.isEmpty()) {
                if (cellProps == null) {
                    cellProps = new StyleTableCellProperties();
                }
                if (cellProps.getVerticalAlign() == null) {
                    cellProps.setVerticalAlign("Standard");
                }
                if (cellProps.getPadding() == null) {
                    cellProps.setPadding("0.035cm");
                }
                if (cellStyle != null) {
                    int offsetX = 0;
                    int offsetY = 0;
                    int padding = 0;
                    String verticalAlign = cellProps.getVerticalAlign();
                    String padValue = cellProps.getPadding();
                    padding = 1 + (int)Math.round((double)ValueHelper.getLenth(padValue) / resizeFactor);
                    if (verticalAlign.equals("middle")) {
                        offsetY = (cellHeight + text.getHeight()) / 2;
                    } else if (verticalAlign.equals("top")) {
                        offsetY = text.getHeight();
                        offsetY += padding;
                    } else {
                        offsetY = cellHeight;
                        offsetY -= padding;
                    }
                    boolean justify = false;
                    StyleParagraphProperties paragraphProps = cell.getStyle().getParagraphProperties();
                    if (paragraphProps != null) {
                        String textAlign = paragraphProps.getTextAlign();
                        if (textAlign != null) {
                            if (textAlign.equals("center")) {
                                int strWidth = text.getWidth();
                                offsetX = (cellWidth - strWidth) / 2;
                            } else if (textAlign.equals("end")) {
                                int strWidth = text.getWidth();
                                offsetX = cellWidth - strWidth - padding;
                            } else if (textAlign.equals("justify")) {
                                justify = true;
                                offsetX += padding;
                            } else {
                                offsetX += padding;
                            }
                        } else {
                            String tableValueType = cell.getTableValueType();
                            if (tableValueType != null && tableValueType.equals("float")) {
                                int strWidth = text.getWidth();
                                offsetX = cellWidth - strWidth - padding;
                            } else {
                                offsetX += padding;
                            }
                        }
                    } else {
                        String tableValueType = cell.getTableValueType();
                        if (tableValueType != null && tableValueType.equals("float")) {
                            int strWidth = text.getWidth();
                            offsetX = cellWidth - strWidth - padding;
                        } else {
                            offsetX += padding;
                        }
                    }
                    if (!justify) {
                        text.draw(x + offsetX, y + offsetY);
                    } else {
                        text.drawJustified(x, y, verticalAlign, padding, cellWidth);
                    }
                }
            }
        }
    }
}

