/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public final class JDOMUtils {
    public static final XMLOutputter OUTPUTTER;
    private static final SAXBuilder BUILDER;

    static {
        Format rawFormat = Format.getRawFormat();
        rawFormat.setLineSeparator("\n");
        OUTPUTTER = new XMLOutputter(rawFormat);
        BUILDER = new SAXBuilder();
        BUILDER.setValidation(false);
    }

    public static Element parseElementString(String xml, Namespace[] namespaces) throws JDOMException {
        return (Element)JDOMUtils.parseString(xml, namespaces).get(0);
    }

    public static List parseString(String xml, Namespace[] namespaces) throws JDOMException {
        String dummy = "<dummy";
        int i = 0;
        while (i < namespaces.length) {
            Namespace ns = namespaces[i];
            dummy = String.valueOf(dummy) + " xmlns:" + ns.getPrefix() + "=\"" + ns.getURI() + "\"";
            ++i;
        }
        xml = String.valueOf(dummy) + ">" + xml + "</dummy>";
        return JDOMUtils.parseStringDocument(xml).getRootElement().removeContent();
    }

    public static Element parseString(String xml) throws JDOMException {
        return JDOMUtils.parseElementString(xml, new Namespace[0]);
    }

    public static synchronized Document parseStringDocument(String xml) throws JDOMException {
        return JDOMUtils.parseStringDocument(xml, BUILDER);
    }

    public static Document parseStringDocument(String xml, SAXBuilder builder) throws JDOMException {
        Document doc = null;
        try {
            doc = builder.build(new StringReader(xml));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static String output(Element xml) {
        return OUTPUTTER.outputString(xml);
    }

    public static String output(Document xml) {
        return OUTPUTTER.outputString(xml);
    }

    public Element mkElem(Element current, String path) {
        String[] items = path.split("/");
        int i = 0;
        while (i < items.length) {
            String item = items[i];
            String[] qname = item.split(":");
            Element elem = qname.length == 1 ? new Element(item) : new Element(qname[1], current.getNamespace(qname[0]));
            current.addContent(elem);
            current = elem;
            ++i;
        }
        return current;
    }
}

