/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class Unzip
extends ZipFile {
    public static void toDir(File zip, File dir) throws IOException {
        Unzip unz = new Unzip(zip);
        unz.unzip(dir);
        unz.close();
    }

    public Unzip(File f) throws ZipException, IOException {
        super(f);
    }

    public void unzip(File destDir) throws ZipException, IOException {
        if (destDir == null) {
            destDir = new File("");
        }
        destDir.mkdirs();
        Enumeration<? extends ZipEntry> en = this.entries();
        while (en.hasMoreElements()) {
            ZipEntry target = en.nextElement();
            this.unzip(destDir, target);
        }
    }

    public void unzip(File destDir, String entryName) throws ZipException, IOException {
        Unzip.unzipEntry(this, this.getEntry(entryName), destDir);
    }

    public void unzip(File destDir, ZipEntry entry) throws ZipException, IOException {
        Unzip.unzipEntry(this, entry, destDir);
    }

    private static void unzipEntry(ZipFile zf, ZipEntry target, File to) throws ZipException, IOException {
        File file = new File(to, target.getName());
        if (target.isDirectory()) {
            file.mkdirs();
        } else {
            int c;
            file.getParentFile().mkdirs();
            InputStream is = zf.getInputStream(target);
            BufferedInputStream bis = new BufferedInputStream(is);
            FileOutputStream fos = new FileOutputStream(file);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            while ((c = bis.read()) != -1) {
                bos.write((byte)c);
            }
            bos.close();
            fos.close();
        }
    }

    public InputStream getInputStream(String entryName) throws IOException {
        ZipEntry entry = this.getEntry(entryName);
        if (entry == null) {
            return null;
        }
        return this.getInputStream(entry);
    }
}

