/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ValueHelper {
    private static final Pattern lenghPattern = Pattern.compile("(\\d+(\\.\\d+)?)(\\p{Alpha}+)?");
    public static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private static final Map<String, Color> colors = new HashMap<String, Color>();

    private static final String[] parseLength2String(String l) {
        Matcher m = lenghPattern.matcher(l);
        if (!m.matches()) {
            throw new IllegalStateException("unable to parse " + l);
        }
        return new String[]{m.group(1), m.group(3)};
    }

    public static final int getLenth(String value) {
        return Math.round(ValueHelper.parseLength(value) * 1000.0f);
    }

    public static final float parseLength(String l) {
        int multiplier;
        String[] valAndUnit = ValueHelper.parseLength2String(l);
        String unit = valAndUnit[1];
        if (unit.equals("cm")) {
            multiplier = 10;
        } else if (unit.equals("mm")) {
            multiplier = 1;
        } else {
            throw new IllegalStateException("unknown unit " + unit);
        }
        return Float.parseFloat(valAndUnit[0]) * (float)multiplier;
    }

    public static final boolean getBoolean(String value) {
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        throw new IllegalArgumentException(String.valueOf(value) + " not a boolean value");
    }

    public static final Color getColor(String value) {
        if (value == null) {
            return null;
        }
        Color c = colors.get(value);
        if (c != null) {
            return c;
        }
        if (value.startsWith("#")) {
            int red = Integer.parseInt(value.substring(1, 3), 16);
            int green = Integer.parseInt(value.substring(3, 5), 16);
            int blue = Integer.parseInt(value.substring(5, 7), 16);
            c = new Color(red, green, blue);
        } else if (value.startsWith("transparent")) {
            c = TRANSPARENT;
        } else {
            System.err.println("unknown color:" + value);
        }
        colors.put(value, c);
        return c;
    }
}

