/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.jopendocument.util.Unzip;

public class Zip {
    private final OutputStream outstream;
    private ZipOutputStream zos;
    private boolean entryOpen;

    public static Zip createFrom(File from, File to, Set excludedEntries) throws ZipException, IOException {
        Unzip unz = new Unzip(from);
        Zip res = new Zip(to);
        Enumeration<? extends ZipEntry> en = unz.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            if (excludedEntries.contains(entry.getName())) continue;
            res.zip(entry.getName(), unz.getInputStream(entry));
        }
        unz.close();
        return res;
    }

    public static void delete(File src, Set entriesName, File dest) throws ZipException, IOException {
        if (dest.exists()) {
            dest.delete();
        }
        Zip.createFrom(src, dest, entriesName).close();
    }

    public Zip(File f) throws FileNotFoundException {
        this(new FileOutputStream(f));
    }

    public Zip(OutputStream out) {
        this.outstream = out;
        this.zos = null;
        this.entryOpen = false;
    }

    public synchronized void close() throws IOException {
        if (this.zos != null) {
            this.zos.close();
        }
    }

    private synchronized ZipOutputStream getOutStream() {
        if (this.zos == null) {
            this.zos = new ZipOutputStream(this.outstream);
        }
        return this.zos;
    }

    public synchronized void zip(File newFile) throws IOException {
        this.zip(newFile.getName(), new BufferedInputStream(new FileInputStream(newFile)));
    }

    public synchronized void zip(String name, InputStream in) throws IOException {
        this.putNextEntry(name);
        byte[] b = new byte[512];
        int len = 0;
        while ((len = in.read(b)) != -1) {
            this.getOutStream().write(b, 0, len);
        }
        this.closeEntry();
    }

    public synchronized OutputStream createEntry(String name) throws IOException {
        this.putNextEntry(name);
        return new BufferedOutputStream(this.getOutStream()){

            @Override
            public void close() throws IOException {
                this.flush();
                Zip.this.closeEntry();
            }
        };
    }

    private final synchronized void putNextEntry(String name) throws IOException, FileNotFoundException {
        if (this.entryOpen) {
            throw new IllegalStateException("previous entry not closed");
        }
        this.entryOpen = true;
        this.getOutStream().putNextEntry(new ZipEntry(name));
    }

    protected final synchronized void closeEntry() throws IOException {
        this.getOutStream().closeEntry();
        this.entryOpen = false;
    }
}

