/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.HashSet;
import java.util.Set;
import org.jopendocument.dom.ContentType;

public enum ContentTypeVersioned {
    TEXT_V1(ContentType.TEXT, "OpenOffice.org", "application/vnd.sun.xml.writer", "text", "sxw"){}
    ,
    GRAPHICS_V1(ContentType.GRAPHICS, "OpenOffice.org", "application/vnd.sun.xml.draw", "drawing", "sxd"){}
    ,
    PRESENTATION_V1(ContentType.PRESENTATION, "OpenOffice.org", "application/vnd.sun.xml.impress", "presentation", "sxi"){}
    ,
    SPREADSHEET_V1(ContentType.SPREADSHEET, "OpenOffice.org", "application/vnd.sun.xml.calc", "spreadsheet", "sxc"){}
    ,
    TEXT(ContentType.TEXT, "OpenDocument", "application/vnd.oasis.opendocument.text", "text", "odt"){}
    ,
    GRAPHICS(ContentType.GRAPHICS, "OpenDocument", "application/vnd.oasis.opendocument.graphics", "drawing", "odg"){}
    ,
    PRESENTATION(ContentType.PRESENTATION, "OpenDocument", "application/vnd.oasis.opendocument.presentation", "presentation", "odp"){}
    ,
    SPREADSHEET(ContentType.SPREADSHEET, "OpenDocument", "application/vnd.oasis.opendocument.spreadsheet", "spreadsheet", "ods"){};

    private final ContentType type;
    private final String version;
    private final String mimeType;
    private final String shortName;
    private final String extension;

    private ContentTypeVersioned(ContentType type, String version, String mimeType, String bodyChildName, String extension) {
        this.type = type;
        this.mimeType = mimeType;
        this.version = version;
        this.shortName = bodyChildName;
        this.extension = extension;
    }

    public final String getVersion() {
        return this.version;
    }

    public final String getShortName() {
        return this.shortName;
    }

    public final String getMimeType() {
        return this.mimeType;
    }

    public final ContentType getType() {
        return this.type;
    }

    public final String getExtension() {
        return this.extension;
    }

    public static ContentTypeVersioned fromType(ContentType type, String version) {
        for (ContentTypeVersioned t : ContentTypeVersioned.fromType(type)) {
            if (!t.getVersion().equals(version)) continue;
            return t;
        }
        return null;
    }

    public static Set<ContentTypeVersioned> fromType(ContentType type) {
        HashSet<ContentTypeVersioned> res = new HashSet<ContentTypeVersioned>();
        ContentTypeVersioned[] contentTypeVersionedArray = ContentTypeVersioned.values();
        int n = contentTypeVersionedArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContentTypeVersioned t = contentTypeVersionedArray[n2];
            if (t.getType().equals((Object)type)) {
                res.add(t);
            }
            ++n2;
        }
        return res;
    }

    public static ContentTypeVersioned fromMime(String mime) {
        ContentTypeVersioned[] contentTypeVersionedArray = ContentTypeVersioned.values();
        int n = contentTypeVersionedArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContentTypeVersioned t = contentTypeVersionedArray[n2];
            if (t.getMimeType().equals(mime)) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    static ContentTypeVersioned fromClass(String name) {
        return ContentTypeVersioned.fromShortName("OpenOffice.org", name);
    }

    static ContentTypeVersioned fromBody(String name) {
        return ContentTypeVersioned.fromShortName("OpenDocument", name);
    }

    private static ContentTypeVersioned fromShortName(String version, String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        ContentTypeVersioned[] contentTypeVersionedArray = ContentTypeVersioned.values();
        int n = contentTypeVersionedArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContentTypeVersioned t = contentTypeVersionedArray[n2];
            if (t.shortName.equals(name) && t.getVersion().equals(version)) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    /* synthetic */ ContentTypeVersioned(String string, int n, ContentType contentType, String string2, String string3, String string4, String string5, ContentTypeVersioned contentTypeVersioned) {
        this(contentType, string2, string3, string4, string5);
    }
}

