/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.spreadsheet.CalcNode;

public class ODFrame
extends CalcNode {
    private static final String UNIT = "mm";
    private static final Pattern lenghPattern = Pattern.compile("(\\d+(\\.\\d+)?)(\\p{Alpha}+)?");
    private final float width = ODFrame.parseLength(this.getSVGAttr("width"));
    private final float height = ODFrame.parseLength(this.getSVGAttr("height"));

    private static final String[] parseLength2String(String l) {
        Matcher m = lenghPattern.matcher(l);
        if (!m.matches()) {
            throw new IllegalStateException("unable to parse " + l);
        }
        return new String[]{m.group(1), m.group(3)};
    }

    public static final float parseLength(String l) {
        int multiplier;
        String[] valAndUnit = ODFrame.parseLength2String(l);
        String unit = valAndUnit[1];
        if (unit.equals("cm")) {
            multiplier = 10;
        } else if (unit.equals(UNIT)) {
            multiplier = 1;
        } else {
            throw new IllegalStateException("unknown unit " + unit);
        }
        return Float.parseFloat(valAndUnit[0]) * (float)multiplier;
    }

    public ODFrame(Element frame) {
        super(frame);
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    private Namespace getSVG() {
        return this.getElement().getNamespace("svg");
    }

    public String getSVGAttr(String name) {
        return this.getElement().getAttributeValue(name, this.getSVG());
    }

    public void setSVGAttr(String name, String val) {
        this.getElement().setAttribute(name, val, this.getSVG());
    }

    public void setSVGAttr(String name, double val) {
        this.setSVGAttr(name, String.valueOf(val) + this.getUnit());
    }

    public final float getRatio() {
        return this.width / this.height;
    }

    public final float getX() {
        return ODFrame.parseLength(this.getSVGAttr("x"));
    }

    public final float getY() {
        return ODFrame.parseLength(this.getSVGAttr("y"));
    }

    public final String getUnit() {
        return UNIT;
    }
}

