/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import org.jopendocument.util.cache.CacheResult;
import org.jopendocument.util.cache.CacheWatcher;
import org.jopendocument.util.cache.CacheWatcherFactory;
import org.jopendocument.util.cache.ICache;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ICacheTest {
    private final ThreadGroup thg = new ThreadGroup("testjunit"){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            ICacheTest.this.threadException = e;
        }
    };
    private static final int delay = 1;
    private ICache<String, Object, Object> cache;
    protected Throwable threadException;

    private Thread launch(String name, Runnable runnable) {
        Thread res = new Thread(this.thg, runnable, name);
        res.start();
        Thread.yield();
        return res;
    }

    private void join(Thread t) throws Throwable {
        t.join();
        if (this.threadException != null) {
            Throwable thw = this.threadException;
            this.threadException = null;
            throw thw;
        }
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.cache = new ICache(1);
    }

    @After
    public void tearDown() throws Exception {
        this.cache = null;
    }

    @Test
    public void testWatcher() throws NoSuchMethodException {
        ICache cache = new ICache(1);
        cache.setWatcherFactory(new CacheWatcherFactory<String, String>(){

            @Override
            public CacheWatcher<String> createWatcher(ICache<String, ?, String> cache, String obj) throws Exception {
                class BogusCacheWatcher<K>
                extends CacheWatcher<K> {
                    public BogusCacheWatcher(ICache<K, ?, ?> c) {
                        super(c);
                    }

                    public void clear() {
                        this.clearCache();
                    }
                }
                return new BogusCacheWatcher<String>(cache);
            }
        });
        String sel = "SELECT * FROM CONTACT";
        ArrayList r = new ArrayList();
        Set<CacheWatcher<String>> put = cache.put("SELECT * FROM CONTACT", r, Collections.singleton("CONTACT_TABLE"));
        BogusCacheWatcher cw = (BogusCacheWatcher)put.iterator().next();
        Assert.assertSame(r, cache.get("SELECT * FROM CONTACT").getRes());
        cw.clear();
        Assert.assertSame((Object)CacheResult.State.NOT_IN_CACHE, (Object)cache.get("SELECT * FROM CONTACT").getState());
    }

    @Test
    public void testInterrupt() throws Throwable {
        this.getCache().addRunning("SELECT *");
        Thread tInt = this.launch("test interrupt", new Runnable(){

            @Override
            public void run() {
                CacheResult res = ICacheTest.this.getCache().get("SELECT *");
                Assert.assertSame((Object)CacheResult.State.INTERRUPTED, (Object)res.getState());
            }
        });
        tInt.interrupt();
        this.join(tInt);
        this.getCache().removeRunning("SELECT *");
    }

    @Test
    public void testGet() throws Throwable {
        Assert.assertEquals((Object)0, (Object)this.getCache().size());
        Assert.assertSame((Object)CacheResult.State.NOT_IN_CACHE, (Object)this.getCache().get("SELECT 1").getState());
        this.getCache().put("SELECT 1", new Integer(1), Collections.singleton(1));
        Thread t = this.launch("test timeout", new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Assert.fail(e.getMessage());
                }
                Assert.assertSame((Object)CacheResult.State.NOT_IN_CACHE, (Object)ICacheTest.this.getCache().get("SELECT 1").getState());
            }
        });
        Assert.assertEquals(new Integer(1), this.getCache().get("SELECT 1").getRes());
        this.join(t);
    }

    @Test
    public void testRunning() throws Throwable {
        String sel = "SELECT 2";
        Assert.assertFalse(this.getCache().isRunning("SELECT 2"));
        this.getCache().addRunning("SELECT 2");
        Assert.assertTrue(this.getCache().isRunning("SELECT 2"));
        final Vector t2Res = new Vector();
        final CountDownLatch latch = new CountDownLatch(1);
        Thread t2 = this.launch("test running", new Runnable(){

            @Override
            public void run() {
                t2Res.add("begun");
                latch.countDown();
                t2Res.add(ICacheTest.this.getCache().get("SELECT 2").getRes());
            }
        });
        latch.await();
        Assert.assertEquals((Object)1, (Object)t2Res.size());
        Thread.sleep(20L);
        Assert.assertEquals((Object)Thread.State.WAITING, (Object)t2.getState());
        Object two = new Object();
        Assert.assertTrue(this.getCache().isRunning("SELECT 2"));
        this.getCache().put("SELECT 2", two, Collections.emptySet());
        Assert.assertFalse(this.getCache().isRunning("SELECT 2"));
        this.join(t2);
        Assert.assertSame(two, t2Res.get(1));
    }

    @Test
    public void testCheck() {
        Object nul = new Object();
        this.getCache().put("SELECT NULL", nul, Collections.emptySet());
        Assert.assertSame(nul, this.getCache().check("SELECT NULL").getRes());
        Assert.assertFalse(this.getCache().isRunning("SELECT NULL"));
    }

    @Test
    public void testSizeAndClear() {
        ICache cache = new ICache(600, 1);
        cache.put("a", "A", Collections.emptySet());
        Assert.assertEquals((Object)1, (Object)cache.size());
        cache.put("b", "B", Collections.emptySet());
        Assert.assertEquals((Object)1, (Object)cache.size());
        Assert.assertSame((Object)CacheResult.State.NOT_IN_CACHE, (Object)cache.get("a").getState());
    }

    @Test
    public void testClear() {
        this.getCache().put("a", "A", Collections.emptySet());
        Assert.assertEquals((Object)1, (Object)this.getCache().size());
        this.getCache().clear("a");
        Assert.assertEquals((Object)0, (Object)this.getCache().size());
        this.getCache().clear("b");
        Assert.assertEquals((Object)0, (Object)this.getCache().size());
    }

    private ICache<String, Object, Object> getCache() {
        return this.cache;
    }
}

