/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.HashMap;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jopendocument.dom.OOXML;
import org.jopendocument.util.JDOMUtils;

public class OOXMLTest
extends TestCase {
    private static final OOXML xml = OOXML.get("OpenOffice.org");

    public void testGetLineBreak() {
        Element lineBreak = xml.getLineBreak();
        OOXMLTest.assertEquals((String)OOXML.getLineBreakS(), (String)("<" + lineBreak.getNamespacePrefix() + ":" + lineBreak.getName() + "/>"));
    }

    public void testGetTab() {
        Element tab = xml.getTab();
        OOXMLTest.assertEquals((String)OOXML.getTabS(), (String)("<" + tab.getNamespacePrefix() + ":" + tab.getName() + "/>"));
    }

    public void testEncodeRT() {
        HashMap<String, String> styles = new HashMap<String, String>();
        styles.put("b", "Gras");
        styles.put("gris", "Gris");
        String expected = "<text:span xmlns:text=\"http://openoffice.org/2000/text\">4 &lt; <text:span text:style-name=\"Gras\">5</text:span></text:span>";
        OOXMLTest.assertEquals((String)"<text:span xmlns:text=\"http://openoffice.org/2000/text\">4 &lt; <text:span text:style-name=\"Gras\">5</text:span></text:span>", (String)JDOMUtils.output(xml.encodeRT("4 < [b]5[/b]", styles)));
    }

    public void testEncodeWS() {
        String s = "hi\thow are   you ?\n[That] was >= 3 and <=3 spaces";
        String expected = "hi<text:tab-stop/>how are<text:s text:c=\"3\"/>you ?<text:line-break/>[That] was &gt;= 3 and &lt;=3 spaces";
        OOXMLTest.assertEquals((String)expected, (String)OOXML.encodeOOWS("hi\thow are   you ?\n[That] was >= 3 and <=3 spaces"));
        expected = "<text:span xmlns:text=\"http://openoffice.org/2000/text\">hi<text:tab-stop />how are<text:s text:c=\"3\" />you ?<text:line-break />[That] was &gt;= 3 and &lt;=3 spaces</text:span>";
        OOXMLTest.assertEquals((String)expected, (String)JDOMUtils.output(xml.encodeWS("hi\thow are   you ?\n[That] was >= 3 and <=3 spaces")));
    }
}

