/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.NS;
import org.jopendocument.dom.spreadsheet.CalcNode;
import org.jopendocument.dom.spreadsheet.Row;

public class Cell
extends CalcNode {
    protected static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("'PT'HH'H'mm'M'ss'S'");
    protected static final SimpleDateFormat OODateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH':'mm':'ss");
    protected final Row parent;

    static final Element createEmpty(NS ns) {
        return Cell.createEmpty(ns, 1);
    }

    static final Element createEmpty(NS ns, int count) {
        Element e = new Element("table-cell", ns.getTABLE());
        if (count > 1) {
            e.setAttribute("number-columns-repeated", String.valueOf(count), ns.getTABLE());
        }
        return e;
    }

    Cell(Row parent, Element elem) {
        super(elem);
        this.parent = parent;
    }

    protected final NS getNS() {
        return this.parent.getSheet().getSpreadSheet().getNS();
    }

    protected final Namespace getValueNS() {
        return this.getNS().getVersion().equals("OpenDocument") ? this.getNS().getOFFICE() : this.getNS().getTABLE();
    }

    protected final String getType() {
        return this.getElement().getAttributeValue("value-type", this.getValueNS());
    }

    public final String getStyle() {
        return this.getElement().getAttributeValue("style-name", this.getNS().getTABLE());
    }

    private final String getValue(String attrName) {
        return this.getElement().getAttributeValue(attrName, this.getValueNS());
    }

    public Object getValue() {
        if (this.getType() == null || this.getType().equals("string")) {
            String attr = this.getValue("string-value");
            if (attr != null) {
                return attr;
            }
            Element child = this.getElement().getChild("p", this.getNS().getTEXT());
            return child == null ? "" : child.getText();
        }
        if (this.getType().equals("float") || this.getType().equals("currency") || this.getType().equals("percentage")) {
            String attr = this.getValue("value");
            return Float.valueOf(attr);
        }
        if (this.getType().equals("date")) {
            String attr = this.getValue("date-value");
            try {
                return OODateFormat.parse(attr);
            }
            catch (ParseException e) {
                throw new IllegalStateException("invalid date");
            }
        }
        if (this.getType().equals("time")) {
            String attr = this.getValue("time-value");
            try {
                return TIME_FORMAT.parseObject(attr);
            }
            catch (ParseException e) {
                throw new IllegalStateException("invalid date");
            }
        }
        throw new IllegalStateException("unknown type: " + this.getType());
    }

    public boolean isValid() {
        return !this.getElement().getName().equals("covered-table-cell");
    }
}

