/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.template.statements;

import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.template.TemplateException;
import org.jopendocument.dom.template.statements.Statement;
import org.jopendocument.util.JDOMUtils;

public abstract class BaseStatement
extends Statement {
    public BaseStatement(String name) {
        super(name);
    }

    @Override
    public boolean matches(Element elem) {
        return elem.getName().equals("script") && elem.getNamespacePrefix().equals("text") && elem.getAttributeValue("language", elem.getNamespace("script")).equals("JODScript") && elem.getText().trim().startsWith("<" + this.getName());
    }

    @Override
    public void prepare(Element scriptElem) throws TemplateException {
        this.prepare(scriptElem, this.parseScript(scriptElem.getText()));
    }

    protected abstract void prepare(Element var1, Element var2) throws TemplateException;

    private Element parseScript(String text) throws TemplateException {
        Element command = null;
        try {
            command = JDOMUtils.parseElementString(text, new Namespace[0]);
        }
        catch (Exception documentException) {
            throw new TemplateException("invalid script: " + text, documentException);
        }
        return command;
    }

    protected static void removeSection(Element elem) {
        if (elem.getQualifiedName().equals("text:section")) {
            BaseStatement.pullUp(elem);
        }
    }
}

