/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.model.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jopendocument.model.style.StyleStyle;
import org.jopendocument.model.table.TableCoveredTableCell;
import org.jopendocument.model.table.TableTable;
import org.jopendocument.model.table.TableTableCell;
import org.jopendocument.model.table.TableTableColumn;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"tableTableCellOrTableCoveredTableCell"})
@XmlRootElement(name="table:table-row")
public class TableTableRow {
    int id = 0;
    static int count = 0;
    @XmlAttribute(name="table:number-rows-repeated")
    @XmlJavaTypeAdapter(value=NormalizedStringAdapter.class)
    protected int tableNumberRowsRepeated = 1;
    @XmlAttribute(name="table:style-name")
    @XmlJavaTypeAdapter(value=NormalizedStringAdapter.class)
    protected String tableStyleName;
    @XmlAttribute(name="table:visibility")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String tableVisibility;
    @XmlAttribute(name="table:default-cell-style-name")
    @XmlJavaTypeAdapter(value=NormalizedStringAdapter.class)
    protected String tableDefaultCellStyleName;
    @XmlElements(value={@XmlElement(name="table:table-cell", required=true, type=TableTableCell.class), @XmlElement(name="table:covered-table-cell", required=true, type=TableCoveredTableCell.class)})
    protected List<Object> tableTableCellOrTableCoveredTableCell;
    private TableTable table;
    ArrayList<TableTableCell> allCells;
    Vector<TableTableCell> cells = new Vector();
    int cachedFromCol;
    int cachedToCol = -1;
    TableTableCell[] cachedCellsInRange;

    public TableTableRow() {
        this.id = count++;
    }

    public int getTableNumberRowsRepeated() {
        return this.tableNumberRowsRepeated;
    }

    public void setTableNumberRowsRepeated(String value) {
        if (value != null) {
            this.tableNumberRowsRepeated = Integer.valueOf(value);
        }
    }

    public String getTableStyleName() {
        return this.tableStyleName;
    }

    public void setTableStyleName(String value) {
        this.tableStyleName = value;
    }

    public StyleStyle getStyle() {
        if (this.tableStyleName == null) {
            return null;
        }
        return this.table.getRowStyle(this.tableStyleName);
    }

    public String getTableVisibility() {
        if (this.tableVisibility == null) {
            return "visible";
        }
        return this.tableVisibility;
    }

    public void setTableVisibility(String value) {
        this.tableVisibility = value;
    }

    public String getTableDefaultCellStyleName() {
        return this.tableDefaultCellStyleName;
    }

    public void setTableDefaultCellStyleName(String value) {
        this.tableDefaultCellStyleName = value;
    }

    public List<Object> getTableTableCellOrTableCoveredTableCell() {
        if (this.tableTableCellOrTableCoveredTableCell == null) {
            this.tableTableCellOrTableCoveredTableCell = new ArrayList<Object>();
        }
        return this.tableTableCellOrTableCoveredTableCell;
    }

    public void addCell(TableTableCell c) {
        this.cells.add(c);
    }

    void computeAllCells() {
        this.allCells = new ArrayList();
        int index = 0;
        while (index < this.cells.size()) {
            TableTableCell c = this.cells.get(index);
            int colPosition = this.allCells.size();
            int repeated = c.getTableNumberColumnsRepeated();
            if (index == this.cells.size() - 1) {
                repeated = this.getTable().getPrintStopCol() - this.allCells.size() + 1;
            }
            int i = 0;
            while (i < repeated) {
                TableTableColumn col = this.table.getColumnAtPosition(colPosition + i);
                TableTableCell cc = c.cloneCell();
                cc.setRowAndColumn(this, col);
                this.allCells.add(cc);
                ++i;
            }
            ++index;
        }
    }

    public TableTableCell[] getCellsInRange(int fromCol, int toCol) {
        if (this.allCells == null) {
            this.computeAllCells();
        }
        if (this.cachedFromCol == fromCol && this.cachedToCol == toCol) {
            return this.cachedCellsInRange;
        }
        TableTableCell[] result = new TableTableCell[toCol - fromCol + 1];
        int index = 0;
        int i = fromCol;
        while (i <= toCol) {
            TableTableCell e;
            result[index] = e = this.allCells.get(i);
            ++index;
            ++i;
        }
        this.cachedCellsInRange = result;
        this.cachedFromCol = fromCol;
        this.cachedToCol = toCol;
        return result;
    }

    public int getHeight() {
        if (this.getStyle() == null) {
            return 4200;
        }
        return this.getStyle().getStyleTableRowProperties().getHeight();
    }

    public void setTable(TableTable t) {
        this.table = t;
    }

    public TableTable getTable() {
        return this.table;
    }

    public String toString() {
        return "TableRow" + this.id;
    }

    public String getText() {
        String t = "";
        int index = 0;
        while (index < this.cells.size()) {
            TableTableCell c = this.cells.get(index);
            t = String.valueOf(t) + c.getTextP();
            ++index;
        }
        return t;
    }
}

