/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jopendocument.model.style.StyleStyle;
import org.jopendocument.model.style.StyleTextProperties;
import org.jopendocument.model.text.TextP;
import org.jopendocument.model.text.TextSpan;
import org.jopendocument.renderer.ODTCellTextItem;
import org.jopendocument.renderer.ODTCellTextLineItem;

public class ODTCellText {
    private List<ODTCellTextItem> items = new Vector<ODTCellTextItem>();
    private TextP textP;
    private Graphics2D g2;
    private double resizeFactor;
    private StyleStyle cellTextStyle;

    public ODTCellText(Graphics2D g, TextP textp, double resizeFactor, StyleStyle cellStyle) {
        this.textP = textp;
        this.g2 = g;
        this.resizeFactor = resizeFactor;
        if (cellStyle == null) {
            throw new IllegalArgumentException("Default style null");
        }
        this.cellTextStyle = cellStyle;
        this.computeItems();
    }

    public String getFullText() {
        String t = "";
        List<TextSpan> lt = this.textP.getTextSpans();
        for (TextSpan tp : lt) {
            if (tp.getValue() == null) continue;
            t = String.valueOf(t) + tp.getValue();
        }
        return t;
    }

    public boolean isEmpty() {
        List<TextSpan> lt = this.textP.getTextSpans();
        for (TextSpan tp : lt) {
            if (tp.getValue() == null || tp.getValue().length() <= 0) continue;
            return false;
        }
        return true;
    }

    public int getHeight() {
        int maxH = 0;
        for (ODTCellTextItem item : this.items) {
            int height = item.getHeight();
            if (height <= maxH) continue;
            maxH = height;
        }
        return maxH;
    }

    public int getWidth() {
        int w = 0;
        for (ODTCellTextItem item : this.items) {
            int width = item.getWidth();
            w += width;
        }
        return w;
    }

    public void draw(int startX, int y) {
        int x = startX;
        for (ODTCellTextItem item : this.items) {
            Font f = item.getFont();
            this.g2.setFont(f);
            this.g2.setColor(item.getColor());
            String text = item.getText();
            if (text == null) continue;
            this.g2.drawString(text, x, y);
            x += item.getWidth();
        }
    }

    private void computeItems() {
        List<TextSpan> lt = this.textP.getTextSpans();
        for (TextSpan textpan : lt) {
            textpan.setTextStyle(this.mergeStyle(this.cellTextStyle, textpan.getTextStyle()));
            ODTCellTextItem item = new ODTCellTextItem(this.g2, textpan.getValue(), this.resizeFactor, textpan.getTextStyle());
            this.items.add(item);
        }
    }

    private StyleStyle mergeStyle(StyleStyle cellTextStyle, StyleStyle spanTextStyle) {
        StyleStyle s = new StyleStyle();
        StyleTextProperties cellTextProperties = cellTextStyle.getStyleTextProperties();
        StyleTextProperties spanTextProperties = null;
        if (spanTextStyle != null) {
            spanTextProperties = spanTextStyle.getStyleTextProperties();
        }
        s.setTextProperties(this.mergeTextProperties(cellTextProperties, spanTextProperties));
        return s;
    }

    private StyleTextProperties mergeTextProperties(StyleTextProperties cellTextProperties, StyleTextProperties spanTextProperties) {
        StyleTextProperties r = new StyleTextProperties();
        String fontName = null;
        if (spanTextProperties != null) {
            fontName = spanTextProperties.getFontName();
        }
        if (fontName == null && cellTextProperties != null) {
            fontName = cellTextProperties.getFontName();
        }
        if (fontName == null) {
            System.err.println("Assuming default font:Arial");
            fontName = "Arial";
        }
        String fontSize = null;
        if (spanTextProperties != null) {
            fontSize = spanTextProperties.getFontSize();
        }
        if (fontSize == null && cellTextProperties != null) {
            fontSize = cellTextProperties.getFontSize();
        }
        if (fontSize == null) {
            fontSize = "11pt";
        }
        String fontWeight = null;
        if (spanTextProperties != null) {
            fontWeight = spanTextProperties.getFontWeight();
        }
        if (fontWeight == null && cellTextProperties != null) {
            fontWeight = cellTextProperties.getFontWeight();
        }
        if (fontWeight == null) {
            fontWeight = "normal";
        }
        Color fontColor = null;
        if (spanTextProperties != null) {
            fontColor = spanTextProperties.getColor();
        }
        if (fontColor == null && cellTextProperties != null) {
            fontColor = cellTextProperties.getColor();
        }
        if (fontColor == null) {
            fontColor = Color.BLACK;
        }
        r.setFontName(fontName);
        r.setFontSize(fontSize);
        r.setFontWeight(fontWeight);
        r.setColor(fontColor);
        return r;
    }

    public void drawJustified(int x, int y, String verticalAlign, int padding, int cellWidth) {
        int maxLineWidth = cellWidth - 2 * padding;
        ArrayList<ODTCellTextItem> smallitems = new ArrayList<ODTCellTextItem>();
        List<TextSpan> lt = this.textP.getTextSpans();
        for (TextSpan textpan : lt) {
            textpan.setTextStyle(this.mergeStyle(this.cellTextStyle, textpan.getTextStyle()));
            String v = textpan.getValue();
            String[] strings = textpan.getCutedValues();
            int i = 0;
            while (i < strings.length) {
                String s = strings[i].trim();
                ODTCellTextItem item = new ODTCellTextItem(this.g2, s, this.resizeFactor, textpan.getTextStyle());
                smallitems.add(item);
                ++i;
            }
        }
        int w = 0;
        ODTCellTextLineItem currentLine = new ODTCellTextLineItem();
        ArrayList<ODTCellTextLineItem> lines = new ArrayList<ODTCellTextLineItem>();
        lines.add(currentLine);
        int maxHeight = 0;
        for (ODTCellTextItem item : smallitems) {
            int height;
            int widthWithSpace = item.getWidthWithSpace();
            if ((w += widthWithSpace) > maxLineWidth) {
                currentLine = new ODTCellTextLineItem();
                maxHeight = 0;
                w = widthWithSpace;
                lines.add(currentLine);
            }
            if ((height = item.getHeight()) > maxHeight) {
                maxHeight = height;
            }
            currentLine.addItem(item);
        }
        int cx = x + padding;
        int cy = y;
        int i = 0;
        while (i < lines.size()) {
            ODTCellTextLineItem line = (ODTCellTextLineItem)lines.get(i);
            int addSpace = 0;
            int totalSpace = maxLineWidth - line.getTotalWidthWithoutSpace();
            if (line.getSize() > 1 && totalSpace > 0 && i < lines.size() - 1) {
                addSpace = totalSpace / (line.getSize() - 1);
            }
            cy += line.getHeight();
            cy = (int)((double)cy + 1440.0 / this.resizeFactor);
            for (ODTCellTextItem item : line.getItems()) {
                Font f = item.getFont();
                this.g2.setFont(f);
                this.g2.setColor(item.getColor());
                String text = item.getText();
                if (addSpace == 0) {
                    text = String.valueOf(text) + " ";
                    item.setText(text);
                }
                if (text == null) continue;
                this.g2.drawString(text, cx, cy);
                cx += item.getWidth() + addSpace;
            }
            cx = x + padding;
            ++i;
        }
    }
}

