/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.sample;

import com.lowagie.text.DocListener;
import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.renderer.ODTRenderer;

public class SimplePDFGenerator {
    public static void main(String[] args) {
        long t1 = System.nanoTime();
        try {
            OpenDocument doc = new OpenDocument();
            doc.loadFrom("template/invoice.ods");
            Document document = new Document(PageSize.A4);
            File outFile = new File("invoice.pdf");
            PdfDocument pdf = new PdfDocument();
            document.addDocListener((DocListener)pdf);
            FileOutputStream fileOutputStream = new FileOutputStream(outFile);
            PdfWriter writer = PdfWriter.getInstance((Document)pdf, (OutputStream)fileOutputStream);
            pdf.addWriter(writer);
            document.open();
            Rectangle pageSize = document.getPageSize();
            int w = (int)((double)pageSize.getWidth() * 0.9);
            int h = (int)((double)pageSize.getHeight() * 0.95);
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)w, (float)h);
            Graphics2D g2 = tp.createPrinterGraphics((float)w, (float)h, null);
            tp.setWidth((float)w);
            tp.setHeight((float)h);
            ODTRenderer renderer = new ODTRenderer(doc);
            renderer.setIgnoreMargins(true);
            renderer.setPaintMaxResolution(true);
            renderer.setResizeFactor(renderer.getPrintWidth() / (double)w);
            renderer.paintComponent(g2);
            g2.dispose();
            float offsetX = (pageSize.getWidth() - (float)w) / 2.0f;
            float offsetY = (pageSize.getHeight() - (float)h) / 2.0f;
            cb.addTemplate(tp, offsetX, offsetY);
            document.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        long t2 = System.nanoTime();
        System.out.println("Time:" + (t2 - t1) / 1000000L + " ms");
    }
}

