/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.TransformerUtils;
import org.apache.commons.collections.functors.NOPTransformer;
import org.jopendocument.util.CompareUtils;
import org.jopendocument.util.cc.ITransformer;

public class CollectionUtils
extends org.apache.commons.collections.CollectionUtils {
    private static final Pattern COMMA = Pattern.compile("\\p{Space}*,\\p{Space}*");

    public static final <E> String join(Collection<E> c, String sep, ITransformer<E, ?> tf) {
        return CollectionUtils.join(c, sep, tf);
    }

    public static final String join(Collection c, String sep, Transformer tf) {
        if (c.size() == 0) {
            return "";
        }
        StringBuffer res = new StringBuffer(c.size() * 4);
        if (c instanceof RandomAccess && c instanceof List) {
            List list = (List)c;
            int stop = c.size() - 1;
            int i = 0;
            while (i < stop) {
                res.append(tf.transform(list.get(i)));
                res.append(sep);
                ++i;
            }
            res.append(tf.transform(list.get(stop)));
        } else {
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                Object elem = iter.next();
                res.append(tf.transform(elem));
                if (!iter.hasNext()) continue;
                res.append(sep);
            }
        }
        return res.toString();
    }

    public static String join(Collection c, String sep) {
        return CollectionUtils.join(c, sep, NOPTransformer.INSTANCE);
    }

    public static List<String> split(String s) {
        return CollectionUtils.split(s, COMMA);
    }

    public static List<String> split(String s, String sep) {
        return CollectionUtils.split(s, Pattern.compile(sep));
    }

    public static List<String> split(String s, Pattern pattern) {
        return s.length() == 0 ? Collections.emptyList() : Arrays.asList(pattern.split(s));
    }

    public static void delete(List l, int from, int to) {
        l.subList(from, to).clear();
    }

    public static void delete(List l, int from) {
        CollectionUtils.delete(l, from, l.size());
    }

    public static final SortedMap organize(Collection col, List<? extends Transformer> propExtractors, List<? extends Comparator> propComp, Comparator itemOrdering) {
        if (propExtractors.size() == 0) {
            throw new IllegalArgumentException("Empty property extractors");
        }
        if (propComp == null) {
            propComp = Collections.nCopies(propExtractors.size(), null);
        } else if (propExtractors.size() != propComp.size()) {
            throw new IllegalArgumentException("Size mismatch between " + propExtractors + " and " + propComp);
        }
        TreeMap res = new TreeMap(propComp.get(0));
        for (Object item : col) {
            Map m = res;
            int i = 0;
            while (i < propExtractors.size() - 1) {
                Transformer extractor = propExtractors.get(i);
                Object property = extractor.transform(item);
                TreeMap newM = (TreeMap)m.get(property);
                if (newM == null) {
                    newM = new TreeMap(propComp.get(i + 1));
                    m.put(property, newM);
                }
                m = newM;
                ++i;
            }
            Object property = propExtractors.get(propExtractors.size() - 1).transform(item);
            TreeSet s = (TreeSet)m.get(property);
            if (s == null) {
                s = new TreeSet(itemOrdering);
                m.put(property, s);
            }
            s.add(item);
        }
        return res;
    }

    public static final List flatten(Map hierarchy, Transformer itemTransf) {
        ArrayList<Object> res = new ArrayList<Object>();
        for (Object obj : hierarchy.keySet()) {
            res.add(obj);
            Object value = hierarchy.get(obj);
            if (value instanceof Map) {
                res.addAll(CollectionUtils.flatten((Map)value, itemTransf));
                continue;
            }
            if (value instanceof Collection) {
                Collection items = (Collection)value;
                for (Object item : items) {
                    res.add(itemTransf.transform(item));
                }
                continue;
            }
            throw new IllegalArgumentException("Illegal value: " + value);
        }
        return res;
    }

    public static final List flatten(Map hierarchy) {
        return CollectionUtils.flatten(hierarchy, TransformerUtils.nopTransformer());
    }

    public static <K, V> List[] mapToLists(Map<K, V> map) {
        ArrayList<K> keys = new ArrayList<K>(map.size());
        ArrayList<V> vals = new ArrayList<V>(map.size());
        for (Map.Entry<K, V> e : map.entrySet()) {
            keys.add(e.getKey());
            vals.add(e.getValue());
        }
        return new List[]{keys, vals};
    }

    public static <E> List<Integer> getIndexesChanged(List<E> oldList, List<E> newList) {
        ArrayList<E> shorter;
        ArrayList<E> longer;
        if (newList.size() > oldList.size()) {
            longer = new ArrayList<E>(newList);
            shorter = new ArrayList<E>(oldList);
        } else {
            longer = new ArrayList<E>(oldList);
            shorter = new ArrayList<E>(newList);
        }
        ArrayList<Integer> res = new ArrayList<Integer>();
        int offset = 0;
        while (shorter.size() > 0) {
            if (longer.size() < shorter.size()) {
                throw new IllegalStateException(shorter + " is not a sublist of " + longer);
            }
            if (CompareUtils.equals(shorter.get(0), longer.get(0))) {
                shorter.remove(0);
                longer.remove(0);
            } else {
                longer.remove(0);
                res.add(offset);
            }
            ++offset;
        }
        int i = 0;
        while (i < longer.size()) {
            res.add(i + offset);
            ++i;
        }
        return res;
    }

    public static List<int[]> aggregate(Collection<? extends Number> ints) {
        ArrayList<int[]> res = new ArrayList<int[]>();
        int[] currentInterval = null;
        for (Number number : ints) {
            int index = number.intValue();
            if (currentInterval == null || index != currentInterval[1] + 1) {
                currentInterval = new int[]{index, currentInterval[0]};
                res.add(currentInterval);
                continue;
            }
            currentInterval[1] = index;
        }
        return res;
    }

    public static <T> Set<T> contains(Set<T> col1, Set<T> col2) {
        if (col1.containsAll(col2)) {
            return null;
        }
        HashSet<T> names = new HashSet<T>(col2);
        names.removeAll(col1);
        return names;
    }

    public static <U, T extends U> List<T> castToList(U[] array, Class<T> clazz) throws ClassCastException {
        ArrayList<T> res = new ArrayList<T>(array.length);
        U[] UArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            U item = UArray[n2];
            res.add(clazz.cast(item));
            ++n2;
        }
        return res;
    }

    public static <T> int equalsFromEnd(List<T> a, List<T> b) {
        return CollectionUtils.equals(a, b, true, null);
    }

    public static <T> int equalsFromStart(List<T> a, List<T> b) {
        return CollectionUtils.equals(a, b, false, null);
    }

    public static final <A, B> int equals(List<A> a, List<B> b, boolean fromEnd, ITransformer<A, B> transf) {
        int sizeA = a.size();
        int sizeB = b.size();
        int lastI = Math.min(sizeA, sizeB);
        int i = 0;
        while (i < lastI) {
            B itemB;
            A itemA = a.get(fromEnd ? sizeA - 1 - i : i);
            if (!CompareUtils.equals(transf == null ? itemA : transf.transformChecked(itemA), itemB = b.get(fromEnd ? sizeB - 1 - i : i))) {
                return i;
            }
            ++i;
        }
        return lastI;
    }

    public static <T> Collection<T> inter(Collection<T> a, Collection<T> b) {
        return org.apache.commons.collections.CollectionUtils.intersection(a, b);
    }

    public static <T> Set<T> inter(Set<T> a, Set<T> b) {
        if (a == b) {
            return a;
        }
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.size() > b.size()) {
            return CollectionUtils.inter(b, a);
        }
        HashSet<T> res = new HashSet<T>();
        for (T item : a) {
            if (!b.contains(item)) continue;
            res.add(item);
        }
        return res;
    }

    public static <T> Set<T> inter(Set<T> ... sets) {
        return CollectionUtils.inter(Arrays.asList(sets));
    }

    public static <T> Set<T> inter(List<Set<T>> sets) {
        ArrayList<Set<T>> mutable = new ArrayList<Set<T>>(sets.size());
        for (Set<T> s : sets) {
            if (s == null) continue;
            mutable.add(s);
        }
        if (mutable.isEmpty()) {
            return null;
        }
        if (mutable.size() == 1) {
            return (Set)mutable.get(0);
        }
        int indexMin = CollectionUtils.indexOfMinSize(mutable);
        if (indexMin != 0) {
            mutable.add(0, (Set)mutable.remove(indexMin));
            return CollectionUtils.inter(mutable);
        }
        if (((Set)mutable.get(0)).isEmpty()) {
            return Collections.emptySet();
        }
        mutable.add(0, CollectionUtils.inter((Set)mutable.remove(0), (Set)mutable.remove(0)));
        return CollectionUtils.inter(mutable);
    }

    private static final <T> int indexOfMinSize(List<Set<T>> sets) {
        if (sets.isEmpty()) {
            throw new IllegalArgumentException("empty sets");
        }
        int res = 0;
        int i = 1;
        while (i < sets.size()) {
            if (sets.get(i).size() < sets.get(res).size()) {
                res = i;
            }
            ++i;
        }
        return res;
    }

    public static <T> Collection<T> subtract(Collection<T> a, Collection<? extends T> b) {
        return org.apache.commons.collections.CollectionUtils.subtract(a, b);
    }

    public static <T> Collection<T> substract(Collection<T> a, Collection<? extends T> b) {
        return org.apache.commons.collections.CollectionUtils.subtract(a, b);
    }

    public static <T> T getSole(List<T> l) {
        return l.size() == 1 ? (T)l.get(0) : null;
    }

    public static <T> T getSole(Collection<T> l) {
        return l.size() == 1 ? (T)l.iterator().next() : null;
    }

    public static <T> T getFirst(Collection<T> l) {
        return l.size() > 0 ? (T)l.iterator().next() : null;
    }

    public static <T> T getFirst(List<T> l) {
        return CollectionUtils.getNoExn(l, 0);
    }

    public static <T> T getLast(List<T> l) {
        return CollectionUtils.getNoExn(l, l.size() - 1);
    }

    public static <T> T getNoExn(List<T> l, int index) {
        return index >= 0 && index < l.size() ? (T)l.get(index) : null;
    }
}

