/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.lang.reflect.Method;
import org.jopendocument.util.ExceptionUtils;

public final class CopyUtils {
    public static final <E> E copy(E object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Cloneable) {
            Method m;
            try {
                m = object.getClass().getMethod("clone", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw ExceptionUtils.createExn(IllegalStateException.class, "Cloneable w/o clone()", e);
            }
            try {
                return (E)m.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw ExceptionUtils.createExn(IllegalStateException.class, "clone() failed", e);
            }
        }
        try {
            return (E)object.getClass().getConstructor(object.getClass()).newInstance(object);
        }
        catch (Exception e) {
            throw ExceptionUtils.createExn(IllegalStateException.class, "Copy constructor failed", e);
        }
    }
}

