/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util.cache;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jopendocument.util.cache.ICache;

public abstract class CacheWatcher<K> {
    private final ICache<K, ?, ?> c;
    private final Set<K> keys;

    protected CacheWatcher(ICache<K, ?, ?> c) {
        this.c = c;
        this.keys = new HashSet<K>();
    }

    final synchronized void add(K key) {
        this.keys.add(key);
    }

    final synchronized void remove(K key) {
        this.keys.remove(key);
    }

    public final synchronized void die() {
        this.dying();
        this.clearCache();
    }

    protected void dying() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clearCache() {
        ICache<K, ?, ?> iCache = this.c;
        synchronized (iCache) {
            CacheWatcher cacheWatcher = this;
            synchronized (cacheWatcher) {
                Iterator<K> iter = this.keys.iterator();
                while (iter.hasNext()) {
                    K key = iter.next();
                    iter.remove();
                    this.c.clear(key);
                }
            }
        }
    }
}

