/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODPackageEntry;
import org.jopendocument.dom.ODXMLDocument;
import org.jopendocument.util.CopyUtils;

public class ODSingleXMLDocument
extends ODXMLDocument
implements Cloneable {
    static final Set<String> DONT_PREFIX = new HashSet<String>();
    private static final String COUNT;
    private int numero;
    private final Set<String> stylesNames;
    private final Set<String> listStylesNames;
    private final ODPackage pkg;
    private final ODXMLDocument.ElementTransformer prefixTransf = new ODXMLDocument.ElementTransformer(){

        @Override
        public Element transform(Element elem) throws JDOMException {
            ODSingleXMLDocument.this.prefix(elem, true);
            return elem;
        }
    };
    private final ODXMLDocument.ElementTransformer prefixTransfNoRef = new ODXMLDocument.ElementTransformer(){

        @Override
        public Element transform(Element elem) throws JDOMException {
            ODSingleXMLDocument.this.prefix(elem, false);
            return elem;
        }
    };

    static {
        DONT_PREFIX.add("user-field-decl");
        DONT_PREFIX.add("user-field-get");
        DONT_PREFIX.add("variable-get");
        DONT_PREFIX.add("variable-decl");
        DONT_PREFIX.add("variable-set");
        COUNT = String.valueOf(ODSingleXMLDocument.class.getName()) + "_count";
    }

    public static ODSingleXMLDocument createFromDocument(Document content, Document style) {
        return ODSingleXMLDocument.createFromDocument(content, style, null);
    }

    public static ODSingleXMLDocument createFromDocument(Document content, Document style, Document settings) {
        return ODSingleXMLDocument.createFromDocument(content, style, settings, new ODPackage());
    }

    static ODSingleXMLDocument createFromDocument(Document content, Document style, Document settings, ODPackage files) {
        ODSingleXMLDocument single = new ODSingleXMLDocument(content, files);
        if (single.getChild("body") == null) {
            throw new IllegalArgumentException("no body in " + single);
        }
        single.getDocument().getRootElement().setName("document");
        if (style != null) {
            try {
                single.mergeAllStyles(new ODXMLDocument(style), true);
            }
            catch (JDOMException e) {
                throw new IllegalArgumentException("style is not valid", e);
            }
        }
        if (settings != null) {
            Element officeSettings = (Element)settings.getRootElement().getChildren().get(0);
            single.getDocument().getRootElement().addContent(0, (Element)officeSettings.clone());
        }
        return single;
    }

    public static ODSingleXMLDocument createFromFile(File f) throws JDOMException, IOException {
        return new ODPackage(f).toSingle();
    }

    private static void setCount(Document doc, int count) {
        doc.getRootElement().setAttribute(COUNT, String.valueOf(count));
    }

    private static boolean hasCount(Document doc) {
        return doc.getRootElement().getAttribute(COUNT) != null;
    }

    private static int getCount(Document doc) {
        return Integer.parseInt(doc.getRootElement().getAttributeValue(COUNT));
    }

    public ODSingleXMLDocument(Document content) {
        this(content, new ODPackage());
    }

    private ODSingleXMLDocument(Document content, ODPackage pkg) {
        super(content);
        if (ODSingleXMLDocument.hasCount(this.getDocument())) {
            this.setNumero(ODSingleXMLDocument.getCount(this.getDocument()));
        } else {
            this.setNumero(0);
        }
        this.stylesNames = new HashSet<String>(64);
        this.listStylesNames = new HashSet<String>(16);
        try {
            for (Attribute attr : this.getXPath("./style:style/@style:name").selectNodes(this.getChild("styles"))) {
                this.stylesNames.add(attr.getValue());
            }
            for (Attribute attr : this.getXPath("./style:style/@text:list-style").selectNodes(this.getChild("styles"))) {
                this.listStylesNames.add(attr.getValue());
            }
        }
        catch (JDOMException exn) {
            throw new IllegalArgumentException("can't find styles names.");
        }
        this.pkg = pkg;
        this.pkg.rmFile("styles.xml");
        this.pkg.rmFile("settings.xml");
        this.pkg.putFile("content.xml", this, "text/xml");
    }

    ODSingleXMLDocument(ODSingleXMLDocument doc, ODPackage p) {
        super(doc);
        this.setNumero(doc.numero);
        this.stylesNames = new HashSet<String>(doc.stylesNames);
        this.listStylesNames = new HashSet<String>(doc.listStylesNames);
        this.pkg = p;
    }

    public ODSingleXMLDocument clone() {
        ODPackage copy = new ODPackage(this.pkg);
        return (ODSingleXMLDocument)copy.getContent();
    }

    private void setNumero(int numero) {
        this.numero = numero;
        ODSingleXMLDocument.setCount(this.getDocument(), this.numero);
    }

    public synchronized void add(ODSingleXMLDocument doc) {
        this.add(doc, true);
    }

    public synchronized void add(ODSingleXMLDocument doc, boolean pageBreak) {
        if (this.add(null, 0, doc) && pageBreak) {
            this.getBody().addContent(this.getPageBreak());
        }
    }

    public synchronized void replace(Element elem, ODSingleXMLDocument doc) {
        Element parent = elem.getParentElement();
        this.add(parent, parent.indexOf(elem), doc);
        elem.detach();
    }

    public synchronized boolean add(Element where, int index, ODSingleXMLDocument doc) {
        if (doc == null) {
            return false;
        }
        if (!this.getVersion().equals(doc.getVersion())) {
            throw new IllegalArgumentException("version mismatch");
        }
        this.setNumero(this.numero + 1);
        try {
            this.mergeEmbedded(doc);
            this.mergeSettings(doc);
            this.mergeAllStyles(doc, false);
            this.mergeBody(where, index, doc);
        }
        catch (JDOMException exn) {
            throw new IllegalArgumentException("XML error", exn);
        }
        return true;
    }

    private void mergeAllStyles(ODXMLDocument doc, boolean sameDoc) throws JDOMException {
        this.mergeFontDecls(doc);
        this.mergeStyles(doc);
        this.mergeAutoStyles(doc);
        this.mergeMasterStyles(doc, !sameDoc);
    }

    private void mergeEmbedded(ODSingleXMLDocument doc) {
        this.pkg.rmFile("Thumbnails/thumbnail.png");
        ODPackage opkg = CopyUtils.copy(doc.pkg);
        for (String name : opkg.getEntries()) {
            ODPackageEntry e = opkg.getEntry(name);
            if (ODPackage.isStandardFile(e.getName())) continue;
            this.pkg.putFile(this.prefix(e.getName()), e.getData(), e.getType());
        }
    }

    private void mergeSettings(ODSingleXMLDocument doc) throws JDOMException {
        this.addIfNotPresent(doc, "./office:settings", 0);
    }

    private void mergeFontDecls(ODXMLDocument doc) throws JDOMException {
        if (this.getNS().getVersion().equals("OpenOffice.org")) {
            this.mergeUnique(doc, "font-decls", "style:font-decl");
        } else {
            this.mergeUnique(doc, "font-face-decls", "style:font-face");
        }
    }

    private void mergeStyles(ODXMLDocument doc) throws JDOMException {
        this.mergeUnique(doc, "styles", "style:default-style", "style:family", NOP_ElementTransformer);
        this.stylesNames.addAll(this.mergeUnique(doc, "styles", "style:style"));
        this.addStylesIfNotPresent(doc, "outline-style");
        this.listStylesNames.addAll(this.mergeUnique(doc, "styles", "text:list-style"));
        this.addStylesIfNotPresent(doc, "footnotes-configuration");
        this.addStylesIfNotPresent(doc, "endnotes-configuration");
    }

    private void mergeAutoStyles(ODXMLDocument doc) throws JDOMException {
        List<Element> addedStyles = this.prefixAndAddAutoStyles(doc);
        for (Attribute listStyleName : this.getXPath("./@style:list-style-name").selectNodes(addedStyles)) {
            if (this.listStylesNames.contains(listStyleName.getValue())) continue;
            listStyleName.setValue(this.prefix(listStyleName.getValue()));
        }
    }

    private void mergeMasterStyles(ODXMLDocument doc, boolean ref) throws JDOMException {
        this.mergeUnique(doc, "master-styles", "style:master-page", ref ? this.prefixTransf : this.prefixTransfNoRef);
    }

    private void mergeBody(Element where, int index, ODSingleXMLDocument doc) throws JDOMException {
        this.add(where, index, (ODXMLDocument)doc, this.getBodyPath(), new ODXMLDocument.ElementTransformer(){

            @Override
            public Element transform(Element elem) throws JDOMException {
                if (elem.getName().equals("sequence-decls")) {
                    return null;
                }
                if (elem.getName().equals("user-field-decls")) {
                    ODSingleXMLDocument.this.detachDuplicate(elem);
                }
                if (elem.getName().equals("variable-decls")) {
                    ODSingleXMLDocument.this.detachDuplicate(elem);
                }
                return ODSingleXMLDocument.this.prefixTransf.transform(elem);
            }
        });
    }

    protected final void detachDuplicate(Element elem) throws JDOMException {
        String singularName = elem.getName().substring(0, elem.getName().length() - 1);
        List thisNames = this.getXPath("./text:" + singularName + "s/text:" + singularName + "/@text:name").selectNodes(this.getChild("body"));
        CollectionUtils.transform(thisNames, new Transformer(){

            @Override
            public Object transform(Object obj) {
                return ((Attribute)obj).getValue();
            }
        });
        Iterator iter = elem.getChildren().iterator();
        while (iter.hasNext()) {
            Element decl = (Element)iter.next();
            if (!thisNames.contains(decl.getAttributeValue("name", this.getNS().getTEXT()))) continue;
            iter.remove();
        }
    }

    private final String getBodyPath() {
        return this.getNS().getVersion().equals("OpenOffice.org") ? "./office:body" : "./office:body/office:text";
    }

    public final Element getBody() {
        try {
            return this.getDescendant(this.getBodyPath());
        }
        catch (JDOMException e) {
            throw new IllegalStateException("no body", e);
        }
    }

    void prefix(Element elem, boolean references) throws JDOMException {
        for (Attribute attr : this.getXPath(".//@text:style-name | .//@table:style-name | .//@draw:style-name").selectNodes(elem)) {
            if (this.listStylesNames.contains(attr.getValue()) || this.stylesNames.contains(attr.getValue())) continue;
            attr.setValue(this.prefix(attr.getValue()));
        }
        for (Attribute attr : this.getXPath(".//@style:page-master-name | .//@style:page-layout-name | .//@text:name | .//@form:name | .//@form:property-name").selectNodes(elem)) {
            String parentName = attr.getParent().getName();
            if (DONT_PREFIX.contains(parentName)) continue;
            attr.setValue(this.prefix(attr.getValue()));
        }
        if (references) {
            for (Attribute attr : this.getXPath(".//@xlink:href[../@xlink:show='embed']").selectNodes(elem)) {
                String prefixedPath = this.prefixPath(attr.getValue());
                if (prefixedPath == null) continue;
                attr.setValue(prefixedPath);
            }
        }
    }

    private String prefixPath(String href) {
        boolean inPKGFile;
        URI uri;
        if (this.getVersion().equals("OpenOffice.org")) {
            boolean sharp = href.startsWith("#");
            if (sharp) {
                return "#" + this.prefix(href.substring(1));
            }
            return null;
        }
        try {
            uri = new URI(href);
        }
        catch (URISyntaxException e) {
            uri = null;
        }
        boolean bl = inPKGFile = uri == null || uri.getScheme() == null && uri.getAuthority() == null && uri.getPath().charAt(0) != '/';
        if (inPKGFile) {
            String dotSlash = "./";
            if (href.startsWith("./")) {
                return "./" + this.prefix(href.substring("./".length()));
            }
            return this.prefix(href);
        }
        return null;
    }

    private String prefix(String value) {
        return String.valueOf(this.numero) + "_" + value;
    }

    private List<String> mergeUnique(ODXMLDocument doc, String topElem, String elemToMerge) throws JDOMException {
        return this.mergeUnique(doc, topElem, elemToMerge, NOP_ElementTransformer);
    }

    private List<String> mergeUnique(ODXMLDocument doc, String topElem, String elemToMerge, ODXMLDocument.ElementTransformer addTransf) throws JDOMException {
        return this.mergeUnique(doc, topElem, elemToMerge, "style:name", addTransf);
    }

    private List<String> mergeUnique(ODXMLDocument doc, String topElem, String elemToMerge, String attrFQName, ODXMLDocument.ElementTransformer addTransf) throws JDOMException {
        ArrayList<String> added = new ArrayList<String>();
        Element thisParent = this.getChild(topElem, true);
        XPath xp = this.getXPath("./" + elemToMerge + "/@" + attrFQName);
        List thisElemNames = xp.selectNodes(thisParent);
        CollectionUtils.transform(thisElemNames, new Transformer(){

            @Override
            public Object transform(Object obj) {
                return ((Attribute)obj).getValue();
            }
        });
        for (Attribute attr : xp.selectNodes(doc.getChild(topElem))) {
            if (thisElemNames.contains(attr.getValue())) continue;
            thisParent.addContent(addTransf.transform((Element)attr.getParent().clone()));
            added.add(attr.getValue());
        }
        return added;
    }

    private void addStylesIfNotPresent(ODXMLDocument doc, String elemName) throws JDOMException {
        this.addIfNotPresent(doc, "./office:styles/text:" + elemName);
    }

    private List<Element> prefixAndAddAutoStyles(ODXMLDocument doc) throws JDOMException {
        ArrayList<Element> result = new ArrayList<Element>(128);
        List otherNames = this.getXPath("./*/@style:name").selectNodes(doc.getChild("automatic-styles"));
        for (Attribute attr : otherNames) {
            Element parent = (Element)attr.getParent().clone();
            parent.setAttribute("name", this.prefix(attr.getValue()), this.getNS().getSTYLE());
            this.getChild("automatic-styles").addContent(parent);
            result.add(parent);
        }
        return result;
    }

    public File saveAs(File f) throws IOException {
        return this.pkg.saveAs(f);
    }

    private Element getPageBreak() {
        return new Element("p", this.getNS().getTEXT()).setAttribute("style-name", "PageBreak", this.getNS().getTEXT());
    }
}

