/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.Factory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.NS;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.util.JDOMUtils;
import org.jopendocument.util.XPathUtils;

public class ODXMLDocument {
    public static final List<String> TOP_ELEMENTS;
    private static final List<String> ELEMS_ORDER;
    private final Document content;
    private final String version;
    protected static final ElementTransformer NOP_ElementTransformer;

    static {
        ELEMS_ORDER = new ArrayList<String>(8);
        ELEMS_ORDER.add("meta");
        ELEMS_ORDER.add("settings");
        ELEMS_ORDER.add("script");
        ELEMS_ORDER.add("font-decls");
        ELEMS_ORDER.add("styles");
        ELEMS_ORDER.add("automatic-styles");
        ELEMS_ORDER.add("master-styles");
        ELEMS_ORDER.add("body");
        TOP_ELEMENTS = ELEMS_ORDER;
        NOP_ElementTransformer = new ElementTransformer(){

            @Override
            public Element transform(Element elem) {
                return elem;
            }
        };
    }

    protected ODXMLDocument(Document content, String version) {
        this.content = content;
        this.version = version;
    }

    public ODXMLDocument(Document content) {
        this(content, NS.getParent(content.getRootElement().getNamespace("office")).getVersion());
    }

    public ODXMLDocument(ODXMLDocument doc) {
        this((Document)doc.content.clone(), doc.version);
    }

    public Document getDocument() {
        return this.content;
    }

    public final String getVersion() {
        return this.version;
    }

    public final NS getNS() {
        return NS.get(this.getVersion());
    }

    public final Element getChild(String childName) {
        return this.getChild(childName, false);
    }

    private int findInsertIndex(String childName) {
        int idealIndex = ELEMS_ORDER.indexOf(childName);
        if (idealIndex == -1) {
            throw new IllegalArgumentException(String.valueOf(childName) + " is unknown.");
        }
        if (this.getChild(childName) != null) {
            return -1;
        }
        List children = this.getDocument().getRootElement().getChildren();
        ListIterator iter = children.listIterator();
        while (iter.hasNext()) {
            Element elem = (Element)iter.next();
            if (ELEMS_ORDER.indexOf(elem.getName()) <= idealIndex) continue;
            return iter.previousIndex();
        }
        return children.size();
    }

    private void insertChild(Element child) {
        this.content.getRootElement().getChildren().add(this.findInsertIndex(child.getName()), child);
    }

    public Element getChild(String childName, boolean create) {
        Element child = this.content.getRootElement().getChild(childName, this.getNS().getOFFICE());
        if (create && child == null) {
            child = new Element(childName, this.getNS().getOFFICE());
            this.insertChild(child);
        }
        return child;
    }

    public void setChild(Element elem) {
        if (!elem.getNamespace().equals(this.getNS().getOFFICE())) {
            throw new IllegalArgumentException("all children of a document belong to the office namespace.");
        }
        this.content.getRootElement().removeChildren(elem.getName(), elem.getNamespace());
        this.insertChild(elem);
    }

    protected final Element getDescendant(String path) throws JDOMException {
        return this.getDescendant(path, false);
    }

    protected final Element getDescendant(String path, boolean create) throws JDOMException {
        Element res = (Element)this.getXPath(path).selectSingleNode(this.getDocument().getRootElement());
        if (res == null && create) {
            Element parent = this.getDescendant(XPathUtils.parentOf(path), create);
            Namespace ns = this.getNS().getNS(XPathUtils.namespace(path));
            res = new Element(XPathUtils.localName(path), ns);
            parent.addContent(res);
        }
        return res;
    }

    public final XPath getXPath(String string) throws JDOMException {
        return OOUtils.getXPath(string, this.getVersion());
    }

    public String asString() {
        return JDOMUtils.output(this.content);
    }

    protected void mergeAll(ODXMLDocument other, String path) throws JDOMException {
        this.mergeAll(other, path, null);
    }

    protected void mergeAll(ODXMLDocument other, String path, ElementTransformer addTransf) throws JDOMException {
        this.add(path, -1, other, path, addTransf);
    }

    protected void add(final String lpath, int lindex, ODXMLDocument other, String rpath, ElementTransformer addTransf) throws JDOMException {
        this.add(new Factory(){

            @Override
            public Object create() {
                try {
                    return ODXMLDocument.this.getDescendant(lpath, true);
                }
                catch (JDOMException e) {
                    throw new IllegalStateException("error", e);
                }
            }
        }, lindex, other, rpath, addTransf);
    }

    protected void add(final Element elem, int lindex, ODXMLDocument other, String rpath, ElementTransformer addTransf) throws JDOMException {
        if (elem == null) {
            this.mergeAll(other, rpath, addTransf);
        } else {
            if (!this.getDocument().getRootElement().isAncestor(elem)) {
                throw new IllegalArgumentException(elem + " not part of " + this);
            }
            this.add(new Factory(){

                @Override
                public Object create() {
                    return elem;
                }
            }, lindex, other, rpath, addTransf);
        }
    }

    private void add(Factory elemF, int lindex, ODXMLDocument other, String rpath, ElementTransformer addTransf) throws JDOMException {
        Element toAdd = other.getDescendant(rpath);
        if (toAdd != null) {
            ArrayList<Element> listToAdd;
            ArrayList<Element> cloned = toAdd.cloneContent();
            if (addTransf == null) {
                listToAdd = cloned;
            } else {
                listToAdd = new ArrayList<Element>(cloned.size());
                for (Content content : cloned) {
                    Element transformedElem;
                    if (!(content instanceof Element) || (transformedElem = addTransf.transform((Element)content)) == null) continue;
                    listToAdd.add(transformedElem);
                }
            }
            Element thisElem = (Element)elemF.create();
            if (lindex < 0) {
                thisElem.addContent(listToAdd);
            } else {
                thisElem.addContent(lindex, listToAdd);
            }
        }
    }

    protected final void addIfNotPresent(ODXMLDocument doc, String path) throws JDOMException {
        this.addIfNotPresent(doc, path, -1);
    }

    protected final void addIfNotPresent(ODXMLDocument doc, String path, int index) throws JDOMException {
        Element otherElem;
        Element myElem = this.getDescendant(path);
        if (myElem == null && (otherElem = doc.getDescendant(path)) != null) {
            Element myParent = this.getDescendant(XPathUtils.parentOf(path));
            if (index == -1) {
                myParent.addContent((Element)otherElem.clone());
            } else {
                myParent.addContent(index, (Element)otherElem.clone());
            }
        }
    }

    protected static interface ElementTransformer {
        public Element transform(Element var1) throws JDOMException;
    }
}

