/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jopendocument.dom.NS;
import org.jopendocument.dom.spreadsheet.CalcNode;
import org.jopendocument.dom.spreadsheet.Cell;
import org.jopendocument.dom.spreadsheet.MutableCell;
import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.util.CollectionUtils;

public class Row
extends CalcNode {
    private final Sheet parent;
    private final List<Cell> cells;

    static Element createEmpty(NS ns) {
        return new Element("table-row", ns.getTABLE());
    }

    public Row(Sheet parent, Element tableRowElem) {
        super(tableRowElem);
        this.parent = parent;
        this.cells = new ArrayList<Cell>();
        for (Element cellElem : this.getCellElements()) {
            this.addCellElem(cellElem);
        }
    }

    protected final Sheet getSheet() {
        return this.parent;
    }

    private void addCellElem(Element cellElem) {
        Cell cell = new Cell(this, cellElem);
        this.cells.add(cell);
        String repeatedS = cellElem.getAttributeValue("number-columns-repeated", this.getSheet().getTABLE());
        if (repeatedS != null) {
            int toRepeat = Integer.parseInt(repeatedS) - 1;
            int i = 0;
            while (i < toRepeat) {
                this.cells.add(cell);
                ++i;
            }
        }
    }

    private List<Element> getCellElements() {
        return this.getElement().getChildren();
    }

    protected final Cell getCellAt(int col) {
        return this.cells.get(col);
    }

    protected final Cell getValidCellAt(int col) {
        Cell c = this.getCellAt(col);
        if (!c.isValid()) {
            throw new IllegalArgumentException("invalid cell " + c);
        }
        return c;
    }

    public final MutableCell getMutableCellAt(int col) {
        Cell c = this.getValidCellAt(col);
        if (!(c instanceof MutableCell)) {
            Element element = c.getElement();
            String repeatedS = element.getAttributeValue("number-columns-repeated", this.getSheet().getTABLE());
            if (repeatedS != null) {
                int repeated = Integer.parseInt(repeatedS);
                int firstIndex = this.cells.indexOf(c);
                int lastIndex = firstIndex + repeated - 1;
                int preRepeated = col - firstIndex;
                int postRepeated = lastIndex - col;
                this.casse(element, firstIndex, preRepeated, true);
                element.removeAttribute("number-columns-repeated", this.getSheet().getTABLE());
                this.casse(element, col + 1, postRepeated, false);
            }
            this.cells.set(col, new MutableCell(this, element));
        }
        return (MutableCell)this.getValidCellAt(col);
    }

    private final void casse(Element element, int firstIndex, int repeat, boolean before) {
        if (repeat > 0) {
            Element newElem = (Element)element.clone();
            element.getParentElement().addContent(element.getParent().indexOf(element) + (before ? 0 : 1), newElem);
            newElem.setAttribute("number-columns-repeated", String.valueOf(repeat), this.getSheet().getTABLE());
            Cell preCell = new Cell(this, newElem);
            int i = 0;
            while (i < repeat) {
                this.cells.set(firstIndex + i, preCell);
                ++i;
            }
        }
    }

    void columnCountChanged() {
        int diff = this.getSheet().getColumnCount() - this.cells.size();
        if (diff < 0) {
            CollectionUtils.delete(this.cells, this.getSheet().getColumnCount());
        } else if (diff > 0) {
            Element e = Cell.createEmpty(this.getSheet().getSpreadSheet().getNS(), diff);
            this.getElement().addContent(e);
            this.addCellElem(e);
        }
        if (this.cells.size() != this.getSheet().getColumnCount()) {
            throw new IllegalStateException();
        }
    }
}

