/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.NS;
import org.jopendocument.dom.spreadsheet.CalcNode;
import org.jopendocument.dom.spreadsheet.Cell;
import org.jopendocument.dom.spreadsheet.Column;
import org.jopendocument.dom.spreadsheet.MutableCell;
import org.jopendocument.dom.spreadsheet.Row;
import org.jopendocument.dom.spreadsheet.SpreadSheet;
import org.jopendocument.util.CollectionUtils;

public class Sheet
extends CalcNode {
    private final SpreadSheet parent;
    private final List<Row> rows;
    private final List<Column> cols;
    private static final Pattern REF_PATTERN = Pattern.compile("([\\p{Alpha}]+)([\\p{Digit}]+)");

    static Element createEmpty(NS ns) {
        return new Element("table", ns.getTABLE());
    }

    Sheet(SpreadSheet parent, Element local) {
        super(local);
        this.parent = parent;
        this.rows = this.flatten(false);
        this.cols = this.flatten(true);
    }

    private List<? extends CalcNode> flatten(boolean col) {
        String childName = col ? "column" : "row";
        List children = this.getElement().getChildren("table-" + childName, this.getTABLE());
        ListIterator<Element> iter = children.listIterator();
        while (iter.hasNext()) {
            Element row = (Element)iter.next();
            Attribute repeatedAttr = row.getAttribute("number-" + childName + "s-repeated", this.getTABLE());
            if (repeatedAttr == null) continue;
            row.removeAttribute(repeatedAttr);
            int index = iter.previousIndex();
            int repeated = Integer.parseInt(repeatedAttr.getValue());
            if (repeated > 60000) {
                repeated = 10;
            }
            int i = 0;
            while (i < repeated - 1) {
                Element clone = (Element)row.clone();
                iter.add(clone);
                ++i;
            }
            iter = children.listIterator(index + repeated);
        }
        ArrayList<Column> res = new ArrayList<Column>(children.size());
        for (Element clone : children) {
            res.add((Column)(col ? new Column(clone) : new Row(this, clone)));
        }
        return res;
    }

    public Object getPrintRanges() {
        return this.getElement().getAttributeValue("print-ranges", this.getTABLE());
    }

    public void setPrintRanges(String s) {
        this.getElement().setAttribute("print-ranges", s, this.getTABLE());
    }

    public void removePrintRanges() {
        this.getElement().removeAttribute("print-ranges", this.getTABLE());
    }

    public synchronized void duplicateFirstRows(int nbFirstRows, int nbDuplicate) {
        List children = this.getElement().getChildren("table-row", this.getTABLE());
        ArrayList<Element> clones = new ArrayList<Element>(nbFirstRows * nbDuplicate);
        int i = 0;
        while (i < nbDuplicate) {
            int l = 0;
            while (l < nbFirstRows) {
                Element r = this.rows.get(l).getElement();
                clones.add((Element)r.clone());
                ++l;
            }
            ++i;
        }
        children.addAll(nbFirstRows, clones);
        this.rows.clear();
        for (Element clone : children) {
            this.rows.add(new Row(this, clone));
        }
    }

    public synchronized void insertDuplicatedRows(int rowDuplicated, int nbDuplicate) {
        List children = this.getElement().getChildren("table-row", this.getTABLE());
        ArrayList<Element> clones = new ArrayList<Element>(nbDuplicate);
        int i = 0;
        while (i < nbDuplicate) {
            Element r = this.rows.get(rowDuplicated).getElement();
            clones.add((Element)r.clone());
            ++i;
        }
        children.addAll(rowDuplicated, clones);
        this.rows.clear();
        for (Element clone : children) {
            this.rows.add(new Row(this, clone));
        }
    }

    public final SpreadSheet getSpreadSheet() {
        return this.parent;
    }

    protected final Namespace getTABLE() {
        return this.getSpreadSheet().getNS().getTABLE();
    }

    public Point resolveHint(String ref) {
        if (Sheet.isCellRef(ref)) {
            return Sheet.resolve(ref);
        }
        throw new IllegalArgumentException(String.valueOf(ref) + " is not a cell ref, if it's a named range, you must use it on a SpreadSheet.");
    }

    public boolean isCellValid(int x, int y) {
        if (x > this.getColumnCount()) {
            return false;
        }
        if (y > this.getRowCount()) {
            return false;
        }
        return this.getImmutableCellAt(x, y).isValid();
    }

    public MutableCell getCellAt(int x, int y) {
        return this.getRow(y).getMutableCellAt(x);
    }

    public MutableCell getCellAt(String ref) {
        Point p = this.resolveHint(ref);
        return this.getCellAt(p.x, p.y);
    }

    public void setValueAt(Object val, int x, int y) {
        if (val == null) {
            val = "";
        }
        if (!val.equals(this.getValueAt(x, y))) {
            this.getCellAt(x, y).setValue(val);
        }
    }

    protected final Cell getImmutableCellAt(int x, int y) {
        return this.getRow(y).getCellAt(x);
    }

    protected final Cell getImmutableCellAt(String ref) {
        Point p = this.resolveHint(ref);
        return this.getImmutableCellAt(p.x, p.y);
    }

    public Object getValueAt(int column, int row) {
        return this.getImmutableCellAt(column, row).getValue();
    }

    public Object getStyleAt(int column, int row) {
        return this.getImmutableCellAt(column, row).getStyle();
    }

    public Object getValueAt(String ref) {
        return this.getImmutableCellAt(ref).getValue();
    }

    private Row getRow(int index) {
        return this.rows.get(index);
    }

    private Column getCol(int i) {
        return this.cols.get(i);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.cols.size();
    }

    public void setColumnCount(int newSize) {
        this.setColumnCount(newSize, -1);
    }

    public void ensureColumnCount(int newSize) {
        if (newSize > this.getColumnCount()) {
            this.setColumnCount(newSize);
        }
    }

    public void setColumnCount(int newSize, int colIndex) {
        Element elemToClone = colIndex < 0 ? Column.createEmpty(this.getSpreadSheet().getNS()) : this.getCol(colIndex).getElement();
        int toGrow = newSize - this.getColumnCount();
        if (toGrow < 0) {
            CollectionUtils.delete(this.cols, newSize);
        } else {
            List children = this.getElement().getChildren(elemToClone.getName(), elemToClone.getNamespace());
            int i = 0;
            while (i < toGrow) {
                Element newElem = (Element)elemToClone.clone();
                children.add(newElem);
                this.cols.add(new Column(newElem));
                ++i;
            }
        }
        for (Row r : this.rows) {
            r.columnCountChanged();
        }
    }

    public void ensureRowCount(int newSize) {
        if (newSize > this.getRowCount()) {
            this.setRowCount(newSize);
        }
    }

    public void setRowCount(int newSize) {
        this.setRowCount(newSize, -1);
    }

    public void setRowCount(int newSize, int rowIndex) {
        Element elemToClone;
        if (rowIndex < 0) {
            elemToClone = Row.createEmpty(this.getSpreadSheet().getNS());
            elemToClone.addContent(Cell.createEmpty(this.getSpreadSheet().getNS(), this.getColumnCount()));
        } else {
            elemToClone = this.getRow(rowIndex).getElement();
        }
        int toGrow = newSize - this.getRowCount();
        if (toGrow < 0) {
            CollectionUtils.delete(this.rows, newSize);
        } else {
            List children = this.getElement().getChildren(elemToClone.getName(), elemToClone.getNamespace());
            int i = 0;
            while (i < toGrow) {
                Element newElem = (Element)elemToClone.clone();
                children.add(newElem);
                this.rows.add(new Row(this, newElem));
                ++i;
            }
        }
    }

    public TableModel getTableModel(int column, int row) {
        return new SheetTableModel(row, column, null, null);
    }

    public TableModel getTableModel(int column, int row, int lastCol, int lastRow) {
        return new SheetTableModel(row, column, lastRow, lastCol);
    }

    public TableModel getMutableTableModel(int column, int row) {
        return new MutableTableModel(row, column);
    }

    public void merge(TableModel t, int column, int row) {
        this.merge(t, column, row, false);
    }

    public void merge(TableModel t, int column, int row, boolean includeColNames) {
        int offset = includeColNames ? 1 : 0;
        this.ensureColumnCount(column + t.getColumnCount());
        this.ensureRowCount(row + t.getRowCount() + offset);
        TableModel thisModel = this.getMutableTableModel(column, row);
        if (includeColNames) {
            int x = 0;
            while (x < t.getColumnCount()) {
                thisModel.setValueAt(t.getColumnName(x), 0, x);
                ++x;
            }
        }
        int y = 0;
        while (y < t.getRowCount()) {
            int x = 0;
            while (x < t.getColumnCount()) {
                Object value = t.getValueAt(y, x);
                thisModel.setValueAt(value, y + offset, x);
                ++x;
            }
            ++y;
        }
    }

    static final boolean isCellRef(String ref) {
        return REF_PATTERN.matcher(ref).matches();
    }

    static final Point resolve(String ref) {
        Matcher matcher = REF_PATTERN.matcher(ref);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.valueOf(ref) + " illegal");
        }
        String letters = matcher.group(1);
        String digits = matcher.group(2);
        return new Point(Sheet.toInt(letters), Integer.parseInt(digits) - 1);
    }

    static final int toInt(String col) {
        if (col.length() < 1) {
            throw new IllegalArgumentException("x cannot be empty");
        }
        col = col.toUpperCase();
        int x = 0;
        int i = 0;
        while (i < col.length()) {
            x = x * 26 + (col.charAt(i) - 65 + 1);
            ++i;
        }
        return x - 1;
    }

    private final class MutableTableModel
    extends SheetTableModel {
        private MutableTableModel(int row, int column) {
            super(row, column);
        }

        @Override
        public void setValueAt(Object obj, int rowIndex, int columnIndex) {
            Sheet.this.setValueAt(obj, this.column + columnIndex, this.row + rowIndex);
        }
    }

    private class SheetTableModel
    extends AbstractTableModel {
        protected final int row;
        protected final int column;
        protected final int lastRow;
        protected final int lastCol;

        private SheetTableModel(int row, int column) {
            this(row, column, sheet.getRowCount(), sheet.getColumnCount());
        }

        private SheetTableModel(int row, int column, int lastRow, int lastCol) {
            this.row = row;
            this.column = column;
            this.lastRow = lastRow;
            this.lastCol = lastCol;
        }

        @Override
        public int getColumnCount() {
            return this.lastCol - this.column;
        }

        @Override
        public int getRowCount() {
            return this.lastRow - this.row;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return Sheet.this.getValueAt(this.column + columnIndex, this.row + rowIndex);
        }

        /* synthetic */ SheetTableModel(int n, int n2, SheetTableModel sheetTableModel, SheetTableModel sheetTableModel2) {
            this(n, n2);
        }
    }
}

