/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.model.office;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.jopendocument.model.number.NumberNumberStyle;
import org.jopendocument.model.style.StylePageLayout;
import org.jopendocument.model.style.StyleStyle;

public class OfficeAutomaticStyles {
    private final List<StyleStyle> styles = new Vector<StyleStyle>();
    private final Map<String, StyleStyle> stylesMap = new HashMap<String, StyleStyle>();
    private final Map<String, StyleStyle> cellStyles = new HashMap<String, StyleStyle>();
    private final Map<String, StyleStyle> tableStyles = new HashMap<String, StyleStyle>();
    private final Map<String, StylePageLayout> pagesLayouts = new HashMap<String, StylePageLayout>();
    private final Map<String, NumberNumberStyle> numberStyles = new HashMap<String, NumberNumberStyle>();

    public List<StyleStyle> getStyles() {
        return this.styles;
    }

    public void addStyle(StyleStyle style) {
        this.stylesMap.put(style.getStyleName(), style);
        this.styles.add(style);
    }

    private StyleStyle getStyle(String s, String type) {
        StyleStyle styleStyle = this.stylesMap.get(s);
        if (styleStyle == null) {
            Set<String> t = this.stylesMap.keySet();
            System.err.println(this.styles);
            for (String string : t) {
                System.err.println("Key:" + string);
            }
            throw new IllegalArgumentException("Unable to find Style name:" + s + " type:" + type);
        }
        return styleStyle;
    }

    public StyleStyle getColumnStyle(String s) {
        return this.getStyle(s, "table-column");
    }

    public StyleStyle getRowStyle(String s) {
        if (s == null) {
            throw new IllegalArgumentException("The style name cannot be null");
        }
        return this.getStyle(s, "table-row");
    }

    public StyleStyle getCellStyle(String s) {
        StyleStyle result = this.cellStyles.get(s);
        if (result == null) {
            result = this.getStyle(s, "table-cell");
            this.cellStyles.put(s, result);
        }
        return result;
    }

    public StyleStyle getTextStyle(String s) {
        return this.getStyle(s, "text");
    }

    public StyleStyle getTableStyle(String tableStyleName) {
        if (tableStyleName == null) {
            throw new IllegalArgumentException("null style name");
        }
        StyleStyle result = this.tableStyles.get(tableStyleName);
        if (result == null) {
            result = this.getStyle(tableStyleName, "table");
            this.tableStyles.put(tableStyleName, result);
        }
        return result;
    }

    public void addPageLayout(StylePageLayout l) {
        this.pagesLayouts.put(l.getStyleName(), l);
    }

    public StylePageLayout getStylePageLayoutFromStyleName(String pageLayoutStyleName) {
        return this.pagesLayouts.get(pageLayoutStyleName);
    }

    public String toString() {
        return "OfficeAutomaticStyles";
    }
}

