/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.model.PrintedPage;
import org.jopendocument.print.DocumentPrinter;
import org.jopendocument.renderer.ODTRenderer;

public class ODSViewerPanel
extends JPanel {
    ODTRenderer renderer;
    int mode;
    int zoom = 100;
    private static final int MODE_PAGE = 0;
    private static final int MODE_WIDTH = 1;
    private static final int MODE_ZOOM = 2;
    JScrollPane scroll;
    JPanel viewer = new JPanel();
    final JTextField textFieldZoomValue = new JTextField(5);
    int currentPageIndex = 0;

    public ODSViewerPanel(OpenDocument doc) {
        this(doc, null, true);
    }

    public ODSViewerPanel(OpenDocument doc, boolean ignoreMargin) {
        this(doc, null, ignoreMargin);
    }

    public ODSViewerPanel(final OpenDocument doc, final DocumentPrinter printListener, boolean ignoreMargin) {
        Toolkit.getDefaultToolkit().setDynamicLayout(false);
        this.setOpaque(false);
        this.renderer = new ODTRenderer(doc);
        this.renderer.setIgnoreMargins(ignoreMargin);
        this.updateMode(2, this.zoom);
        JPanel tools = new JPanel();
        JButton buttonFullPage = new JButton("Fit page");
        buttonFullPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ODSViewerPanel.this.updateMode(0, 100);
            }
        });
        tools.add(buttonFullPage);
        JButton buttonFullWidth = new JButton("Fit width");
        buttonFullWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ODSViewerPanel.this.updateMode(1, 100);
            }
        });
        tools.add(buttonFullWidth);
        JButton buttonZoomOut = new JButton("-");
        buttonZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ODSViewerPanel.this.zoom > 30) {
                    ODSViewerPanel.this.updateMode(2, ODSViewerPanel.this.zoom - 20);
                }
            }
        });
        tools.add(buttonZoomOut);
        this.textFieldZoomValue.setEditable(false);
        tools.add(this.textFieldZoomValue);
        JButton buttonZoomIn = new JButton("+");
        buttonZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int z = ODSViewerPanel.this.zoom + 20;
                if (z > 400) {
                    z = 400;
                }
                ODSViewerPanel.this.updateMode(2, z);
            }
        });
        tools.add(buttonZoomIn);
        this.viewer.setOpaque(false);
        this.viewer.setBackground(Color.DARK_GRAY);
        this.viewer.setLayout(null);
        this.renderer.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        this.viewer.add(this.renderer);
        this.setLayout(new BorderLayout());
        this.add((Component)tools, "North");
        this.scroll = new JScrollPane(this.viewer);
        this.scroll.setOpaque(false);
        this.scroll.setHorizontalScrollBarPolicy(32);
        this.scroll.setVerticalScrollBarPolicy(22);
        this.scroll.getHorizontalScrollBar().setUnitIncrement(30);
        this.scroll.getVerticalScrollBar().setUnitIncrement(30);
        ((JComponent)this.scroll.getViewport().getView()).setOpaque(false);
        this.add((Component)this.scroll, "Center");
        this.updateMode(2, this.zoom);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                ODSViewerPanel.this.updateMode(ODSViewerPanel.this.mode, ODSViewerPanel.this.zoom);
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        if (doc.getPrintedPageCount() > 1) {
            final JTextField page = new JTextField(5);
            JButton previousButton = new JButton("<");
            previousButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ODSViewerPanel.this.currentPageIndex > 0) {
                        --ODSViewerPanel.this.currentPageIndex;
                        ODSViewerPanel.this.updatePage(doc.getPrintedPage(ODSViewerPanel.this.currentPageIndex));
                        ODSViewerPanel.this.updatePageCount(doc, page);
                    }
                }
            });
            JButton nextButton = new JButton(">");
            nextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ODSViewerPanel.this.currentPageIndex < doc.getPrintedPageCount() - 1) {
                        ++ODSViewerPanel.this.currentPageIndex;
                        ODSViewerPanel.this.updatePage(doc.getPrintedPage(ODSViewerPanel.this.currentPageIndex));
                        ODSViewerPanel.this.updatePageCount(doc, page);
                    }
                }
            });
            tools.add(previousButton);
            tools.add(page);
            tools.add(nextButton);
        }
        if (printListener != null) {
            JButton buttonPrint = new JButton("Print");
            buttonPrint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    printListener.print(doc);
                }
            });
            tools.add(buttonPrint);
        }
    }

    private void updatePageCount(OpenDocument doc, JTextField page) {
        page.setText(String.valueOf(this.currentPageIndex + 1) + "/" + doc.getPrintedPageCount());
    }

    protected void updatePage(PrintedPage p) {
        this.renderer.setCurrentPage(p);
    }

    private void updateMode(int m, int zoom_value) {
        System.out.println("ODSViewerPanel.updateMode():mode:" + m + " z:" + zoom_value);
        this.mode = m;
        this.zoom = zoom_value;
        int w = this.renderer.getPrintWidthInPixel();
        int h = this.renderer.getPrintHeightInPixel();
        switch (m) {
            case 0: {
                int height = this.getHeight() - this.scroll.getHorizontalScrollBar().getHeight();
                System.out.println("Panel width:" + height + " Renderer W:" + this.renderer.getPrintWidth());
                double resizeH = this.renderer.getPrintHeight() / (double)height;
                System.out.println("resize to:" + resizeH);
                this.renderer.setResizeFactor(resizeH);
                this.zoom = (int)Math.round(36000.0 / resizeH);
                int posx = 0;
                int posy = 0;
                if (this.scroll != null) {
                    posx = (this.scroll.getViewportBorderBounds().width - w) / 2;
                }
                if (posx < 0) {
                    posx = 0;
                }
                if (posy < 0) {
                    posy = 0;
                }
                this.renderer.setLocation(posx, posy);
                break;
            }
            case 1: {
                int width = this.getWidth() - this.scroll.getVerticalScrollBar().getWidth();
                System.out.println("Panel width:" + width + " Renderer W:" + this.renderer.getPrintWidth());
                double resizeW = this.renderer.getPrintWidth() / (double)width;
                System.out.println("resize to:" + resizeW);
                this.renderer.setResizeFactor(resizeW);
                this.zoom = (int)Math.round(36000.0 / resizeW);
                this.renderer.setLocation(0, 0);
                break;
            }
            case 2: {
                this.renderer.setResizeFactor(36000 / zoom_value);
                System.out.println("w:" + this.renderer.getPrintWidthInPixel());
                int posx = 0;
                int posy = 0;
                if (this.scroll != null) {
                    posx = (this.scroll.getViewportBorderBounds().width - w) / 2;
                    posy = (this.scroll.getViewportBorderBounds().height - h) / 2;
                }
                if (posy > 10) {
                    posy = 10;
                }
                System.out.println("ppppossss:" + posx);
                if (posx < 0) {
                    posx = 0;
                }
                if (posy < 0) {
                    posy = 0;
                }
                this.renderer.setLocation(posx, posy);
                if (posx > 0 || posy > 0) {
                    this.renderer.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
                    break;
                }
                this.renderer.setBorder(null);
                break;
            }
        }
        this.textFieldZoomValue.setText(String.valueOf(this.zoom) + " %");
        Dimension size = new Dimension(this.renderer.getPrintWidthInPixel(), this.renderer.getPrintHeightInPixel());
        this.renderer.setSize(this.renderer.getPrintWidthInPixel(), this.renderer.getPrintHeightInPixel());
        this.viewer.setPreferredSize(size);
        this.viewer.revalidate();
        this.repaint();
    }

    public ODTRenderer getRenderer() {
        return this.renderer;
    }
}

