/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.NS;
import org.jopendocument.util.JDOMUtils;

final class Manifest {
    public static final String ENTRY_NAME = "META-INF/manifest.xml";
    private static final DocType DOC_TYPE = new DocType("manifest:manifest", "-//OpenOffice.org//DTD Manifest 1.0//EN", "Manifest.dtd");
    private final String version;
    private final Document doc;

    public Manifest(String version, String mainType) {
        this.version = version;
        this.doc = new Document(new Element("manifest", this.getNS()), (DocType)DOC_TYPE.clone());
        this.addEntry("/", mainType);
    }

    private Namespace getNS() {
        return NS.get(this.version).getNS("manifest");
    }

    public void addEntry(String path, String type) {
        Element elem = new Element("file-entry", this.getNS());
        elem.setAttribute("media-type", type, this.getNS());
        elem.setAttribute("full-path", path, this.getNS());
        this.doc.getRootElement().addContent(elem);
    }

    public String asString() {
        return JDOMUtils.output(this.doc);
    }
}

