/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.OOFileDocument;
import org.jopendocument.dom.OOXMLDocument;
import org.jopendocument.util.ExceptionUtils;
import org.jopendocument.util.JDOMUtils;

public class OOSingleXMLDocument
extends OOXMLDocument {
    static final Set<String> DONT_PREFIX = new HashSet<String>();
    private static final String COUNT;
    private int numero;
    private final Set<String> stylesNames;
    private final Set<String> listStylesNames;
    private final Map<String, byte[]> refFiles;
    private final OOXMLDocument.ElementTransformer prefixTransf = new OOXMLDocument.ElementTransformer(){

        @Override
        public Element transform(Element elem) throws JDOMException {
            OOSingleXMLDocument.this.prefix(elem);
            return elem;
        }
    };

    static {
        DONT_PREFIX.add("user-field-decl");
        DONT_PREFIX.add("user-field-get");
        DONT_PREFIX.add("variable-get");
        DONT_PREFIX.add("variable-decl");
        DONT_PREFIX.add("variable-set");
        COUNT = String.valueOf(OOSingleXMLDocument.class.getName()) + "_count";
    }

    public static OOSingleXMLDocument createFromDocument(Document content, Document style) {
        return OOSingleXMLDocument.createFromDocument(content, style, null);
    }

    public static OOSingleXMLDocument createFromDocument(Document content, Document style, Document settings) {
        return OOSingleXMLDocument.createFromDocument(content, style, settings, Collections.emptyMap());
    }

    public static OOSingleXMLDocument createFromDocument(Document content, Document style, Document settings, Map<String, ?> files) {
        OOSingleXMLDocument single = new OOSingleXMLDocument(content, files);
        if (single.getChild("body") == null) {
            throw new IllegalArgumentException("no body in " + single);
        }
        single.getDocument().getRootElement().setName("document");
        if (style != null) {
            single.add(new OOSingleXMLDocument(style), false);
        }
        if (settings != null) {
            Element officeSettings = (Element)settings.getRootElement().getChildren().get(0);
            single.getDocument().getRootElement().addContent(0, (Element)officeSettings.clone());
        }
        return single;
    }

    public static OOSingleXMLDocument createFromFile(File f) throws JDOMException, IOException {
        return new OOFileDocument(f).toSingle();
    }

    private static void setCount(Document doc, int count) {
        doc.getRootElement().setAttribute(COUNT, String.valueOf(count));
    }

    private static boolean hasCount(Document doc) {
        return doc.getRootElement().getAttribute(COUNT) != null;
    }

    private static int getCount(Document doc) {
        return Integer.parseInt(doc.getRootElement().getAttributeValue(COUNT));
    }

    public OOSingleXMLDocument(Document content) {
        this(content, Collections.emptyMap());
    }

    private OOSingleXMLDocument(Document content, Map<String, ?> files) {
        super(content);
        if (OOSingleXMLDocument.hasCount(this.getDocument())) {
            this.setNumero(OOSingleXMLDocument.getCount(this.getDocument()));
        } else {
            this.setNumero(0);
        }
        this.stylesNames = new HashSet<String>(64);
        this.listStylesNames = new HashSet<String>(16);
        try {
            for (Attribute attr : this.getXPath("./style:style/@style:name").selectNodes(this.getChild("styles"))) {
                this.stylesNames.add(attr.getValue());
            }
            for (Attribute attr : this.getXPath("./style:style/@text:list-style").selectNodes(this.getChild("styles"))) {
                this.listStylesNames.add(attr.getValue());
            }
        }
        catch (JDOMException exn) {
            throw new IllegalArgumentException("can't find styles names.");
        }
        this.refFiles = new HashMap<String, byte[]>();
        try {
            for (Attribute attr : this.getXPath(".//@xlink:href[../@xlink:show='embed']").selectNodes(this.getBody())) {
                String ref = attr.getValue();
                if (ref.length() <= 0) continue;
                if (!files.containsKey(ref)) {
                    throw new IllegalArgumentException(String.valueOf(JDOMUtils.output(attr.getParent())) + " not found in " + files);
                }
                this.refFiles.put(ref, (byte[])files.get(ref));
            }
        }
        catch (JDOMException exn) {
            throw new IllegalArgumentException("can't find linked files.");
        }
    }

    public OOSingleXMLDocument(OOSingleXMLDocument doc) {
        super(doc);
        this.setNumero(doc.numero);
        this.stylesNames = new HashSet<String>(doc.stylesNames);
        this.listStylesNames = new HashSet<String>(doc.listStylesNames);
        this.refFiles = new HashMap<String, byte[]>(doc.refFiles);
    }

    private void setNumero(int numero) {
        this.numero = numero;
        OOSingleXMLDocument.setCount(this.getDocument(), this.numero);
    }

    public synchronized void add(OOSingleXMLDocument doc) {
        this.add(doc, true);
    }

    public synchronized void add(OOSingleXMLDocument doc, boolean pageBreak) {
        if (this.add(null, 0, doc) && pageBreak) {
            this.getBody().addContent(this.getPageBreak());
        }
    }

    public synchronized void replace(Element elem, OOSingleXMLDocument doc) {
        Element parent = elem.getParentElement();
        this.add(parent, parent.indexOf(elem), doc);
        elem.detach();
    }

    public synchronized boolean add(Element where, int index, OOSingleXMLDocument doc) {
        if (doc == null) {
            return false;
        }
        if (!this.getVersion().equals(doc.getVersion())) {
            throw new IllegalArgumentException("version mismatch");
        }
        if (!Collections.disjoint((Collection)this.refFiles.keySet(), (Collection)doc.refFiles.keySet())) {
            throw new IllegalStateException("references with the same name: " + this.refFiles + "\n" + doc.refFiles);
        }
        this.setNumero(this.numero + 1);
        this.refFiles.putAll(doc.refFiles);
        try {
            this.mergeSettings(doc);
            this.mergeFontDecls(doc);
            this.mergeStyles(doc);
            this.mergeAutoStyles(doc);
            this.mergeMasterStyles(doc);
            this.mergeBody(where, index, doc);
        }
        catch (JDOMException exn) {
            throw ExceptionUtils.createExn(IllegalArgumentException.class, "XML error", exn);
        }
        return true;
    }

    private void mergeSettings(OOSingleXMLDocument doc) throws JDOMException {
        this.addIfNotPresent(doc, "./office:settings", 0);
    }

    private void mergeFontDecls(OOSingleXMLDocument doc) throws JDOMException {
        if (this.getNS().getVersion().equals("OpenOffice.org")) {
            this.mergeUnique(doc, "font-decls", "style:font-decl");
        } else {
            this.mergeUnique(doc, "font-face-decls", "style:font-face");
        }
    }

    private void mergeStyles(OOSingleXMLDocument doc) throws JDOMException {
        this.mergeUnique(doc, "styles", "style:default-style", "style:family", NOP_ElementTransformer);
        this.stylesNames.addAll(this.mergeUnique(doc, "styles", "style:style"));
        this.addStylesIfNotPresent(doc, "outline-style");
        this.listStylesNames.addAll(this.mergeUnique(doc, "styles", "text:list-style"));
        this.addStylesIfNotPresent(doc, "footnotes-configuration");
        this.addStylesIfNotPresent(doc, "endnotes-configuration");
    }

    private void mergeAutoStyles(OOSingleXMLDocument doc) throws JDOMException {
        List<Element> addedStyles = this.prefixAndAddAutoStyles(doc);
        for (Attribute listStyleName : this.getXPath("./@style:list-style-name").selectNodes(addedStyles)) {
            if (this.listStylesNames.contains(listStyleName.getValue())) continue;
            listStyleName.setValue(this.prefix(listStyleName.getValue()));
        }
    }

    private void mergeMasterStyles(OOSingleXMLDocument doc) throws JDOMException {
        this.mergeUnique(doc, "master-styles", "style:master-page", this.prefixTransf);
    }

    private void mergeBody(Element where, int index, OOSingleXMLDocument doc) throws JDOMException {
        this.add(where, index, (OOXMLDocument)doc, this.getBodyPath(), new OOXMLDocument.ElementTransformer(){

            @Override
            public Element transform(Element elem) throws JDOMException {
                if (elem.getName().equals("sequence-decls")) {
                    return null;
                }
                if (elem.getName().equals("user-field-decls")) {
                    OOSingleXMLDocument.this.detachDuplicate(elem);
                }
                if (elem.getName().equals("variable-decls")) {
                    OOSingleXMLDocument.this.detachDuplicate(elem);
                }
                return OOSingleXMLDocument.this.prefixTransf.transform(elem);
            }
        });
    }

    protected final void detachDuplicate(Element elem) throws JDOMException {
        String singularName = elem.getName().substring(0, elem.getName().length() - 1);
        List thisNames = this.getXPath("./text:" + singularName + "s/text:" + singularName + "/@text:name").selectNodes(this.getChild("body"));
        CollectionUtils.transform(thisNames, new Transformer(){

            @Override
            public Object transform(Object obj) {
                return ((Attribute)obj).getValue();
            }
        });
        Iterator iter = elem.getChildren().iterator();
        while (iter.hasNext()) {
            Element decl = (Element)iter.next();
            if (!thisNames.contains(decl.getAttributeValue("name", this.getNS().getTEXT()))) continue;
            iter.remove();
        }
    }

    private final String getBodyPath() {
        return this.getNS().getVersion().equals("OpenOffice.org") ? "./office:body" : "./office:body/office:text";
    }

    public final Element getBody() {
        try {
            return this.getDescendant(this.getBodyPath());
        }
        catch (JDOMException e) {
            throw ExceptionUtils.createExn(IllegalStateException.class, "no body", e);
        }
    }

    void prefix(Element elem) throws JDOMException {
        for (Attribute attr : this.getXPath(".//@text:style-name | .//@table:style-name | .//@draw:style-name").selectNodes(elem)) {
            if (this.listStylesNames.contains(attr.getValue()) || this.stylesNames.contains(attr.getValue())) continue;
            attr.setValue(this.prefix(attr.getValue()));
        }
        for (Attribute attr : this.getXPath(".//@style:page-master-name | .//@style:page-layout-name | .//@text:name | .//@form:name | .//@form:property-name").selectNodes(elem)) {
            String parentName = attr.getParent().getName();
            if (DONT_PREFIX.contains(parentName)) continue;
            attr.setValue(this.prefix(attr.getValue()));
        }
    }

    private String prefix(String value) {
        return String.valueOf(this.numero) + "_" + value;
    }

    private List<String> mergeUnique(OOSingleXMLDocument doc, String topElem, String elemToMerge) throws JDOMException {
        return this.mergeUnique(doc, topElem, elemToMerge, NOP_ElementTransformer);
    }

    private List<String> mergeUnique(OOSingleXMLDocument doc, String topElem, String elemToMerge, OOXMLDocument.ElementTransformer addTransf) throws JDOMException {
        return this.mergeUnique(doc, topElem, elemToMerge, "style:name", addTransf);
    }

    private List<String> mergeUnique(OOSingleXMLDocument doc, String topElem, String elemToMerge, String attrFQName, OOXMLDocument.ElementTransformer addTransf) throws JDOMException {
        ArrayList<String> added = new ArrayList<String>();
        Element thisParent = this.getChild(topElem, true);
        XPath xp = this.getXPath("./" + elemToMerge + "/@" + attrFQName);
        List thisElemNames = xp.selectNodes(thisParent);
        CollectionUtils.transform(thisElemNames, new Transformer(){

            @Override
            public Object transform(Object obj) {
                return ((Attribute)obj).getValue();
            }
        });
        for (Attribute attr : xp.selectNodes(doc.getChild(topElem))) {
            if (thisElemNames.contains(attr.getValue())) continue;
            thisParent.addContent(addTransf.transform((Element)attr.getParent().clone()));
            added.add(attr.getValue());
        }
        return added;
    }

    private void addStylesIfNotPresent(OOSingleXMLDocument doc, String elemName) throws JDOMException {
        this.addIfNotPresent(doc, "./office:styles/text:" + elemName);
    }

    private List<Element> prefixAndAddAutoStyles(OOSingleXMLDocument doc) throws JDOMException {
        ArrayList<Element> result = new ArrayList<Element>(128);
        List otherNames = this.getXPath("./*/@style:name").selectNodes(doc.getChild("automatic-styles"));
        for (Attribute attr : otherNames) {
            Element parent = (Element)attr.getParent().clone();
            parent.setAttribute("name", this.prefix(attr.getValue()), this.getNS().getSTYLE());
            this.getChild("automatic-styles").addContent(parent);
            result.add(parent);
        }
        return result;
    }

    public File saveAs(File f) throws IOException {
        OOFileDocument res = this.getFileDoc();
        res.setFile(f);
        res.save();
        return res.getFile();
    }

    private final OOFileDocument getFileDoc() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("content.xml", this.getDocument());
        res.putAll(this.refFiles);
        return new OOFileDocument(res);
    }

    private Element getPageBreak() {
        return new Element("p", this.getNS().getTEXT()).setAttribute("style-name", "PageBreak", this.getNS().getTEXT());
    }
}

