/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.NS;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.util.ExceptionUtils;
import org.jopendocument.util.JDOMUtils;

public class OOXML {
    private static final Map instances = LazyMap.decorate(new HashMap(), new Transformer(){

        @Override
        public Object transform(Object input) {
            return new OOXML((String)input, null);
        }
    });
    private final String version;

    public static OOXML get(String version) {
        return (OOXML)instances.get(version);
    }

    public static final String getTabS() {
        return "<text:tab-stop/>";
    }

    public static final String getLineBreakS() {
        return "<text:line-break/>";
    }

    private static final String rt2oo(String content, String tagName, String styleName) {
        return content.replaceAll("\\[" + tagName + "\\]", "<text:span text:style-name=\"" + styleName + "\">").replaceAll("\\[/" + tagName + "\\]", "</text:span>");
    }

    public static final String encodeOOWS(String s) {
        String tmp = JDOMUtils.OUTPUTTER.escapeElementEntities(s).replaceAll("\n", OOXML.getLineBreakS()).replaceAll("\t", OOXML.getTabS());
        String res = "";
        Pattern p = Pattern.compile("  +");
        Matcher m = p.matcher(tmp);
        int lastEnd = 0;
        while (m.find()) {
            res = String.valueOf(res) + tmp.substring(lastEnd, m.start()) + "<text:s text:c=\"" + m.group().length() + "\"/>";
            lastEnd = m.end();
        }
        res = String.valueOf(res) + tmp.substring(lastEnd);
        return res;
    }

    private OOXML(String version) {
        this.version = version;
    }

    public final String getVersion() {
        return this.version;
    }

    private NS getNS() {
        return NS.get(this.getVersion());
    }

    public final Element getLineBreak() {
        return new Element("line-break", this.getNS().getTEXT());
    }

    public final Element getTab() {
        return new Element("tab-stop", this.getNS().getTEXT());
    }

    protected final List encodeRT_L(String content, Map styles) {
        String res = JDOMUtils.OUTPUTTER.escapeElementEntities(content);
        for (Map.Entry e : styles.entrySet()) {
            res = OOXML.rt2oo(res, (String)e.getKey(), (String)e.getValue());
        }
        try {
            return JDOMUtils.parseString(res, this.getNS().getALL());
        }
        catch (JDOMException e) {
            throw ExceptionUtils.createExn(IllegalStateException.class, "could not parse " + res, e);
        }
    }

    public final Element encodeRT(String content, Map styles) {
        return new Element("span", this.getNS().getTEXT()).addContent(this.encodeRT_L(content, styles));
    }

    private Element createSpaces(String spacesS) {
        return new Element("s", this.getNS().getTEXT()).setAttribute("c", String.valueOf(spacesS.length()), this.getNS().getTEXT());
    }

    public final Element encodeWS(String s) {
        return new Element("span", this.getNS().getTEXT()).setContent(this.encodeWSasList(s));
    }

    private final List<Content> encodeWSasList(String s) {
        ArrayList<Content> res = new ArrayList<Content>();
        Matcher m = Pattern.compile("\n|\t| {2,}").matcher(s);
        int last = 0;
        while (m.find()) {
            res.add(new Text(s.substring(last, m.start())));
            switch (m.group().charAt(0)) {
                case '\n': {
                    res.add(this.getLineBreak());
                    break;
                }
                case '\t': {
                    res.add(this.getTab());
                    break;
                }
                case ' ': {
                    res.add(this.createSpaces(m.group()));
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown item: " + m.group());
                }
            }
            last = m.end();
        }
        res.add(new Text(s.substring(last)));
        return res;
    }

    public final void encodeWS(Text t) {
        Parent parent = t.getParent();
        int ind = parent.indexOf(t);
        t.detach();
        parent.getContent().addAll(ind, this.encodeWSasList(t.getText()));
    }

    public final Element encodeWS(Element elem) {
        XPath path;
        try {
            path = OOUtils.getXPath(".//text()", NS.getVersion(elem));
        }
        catch (JDOMException e) {
            throw ExceptionUtils.createExn(IllegalStateException.class, "cannot create XPath", e);
        }
        try {
            for (Text t : new ArrayList(path.selectNodes(elem))) {
                this.encodeWS(t);
            }
        }
        catch (JDOMException e) {
            throw ExceptionUtils.createExn(IllegalArgumentException.class, "cannot find text nodes of " + elem, e);
        }
        return elem;
    }

    /* synthetic */ OOXML(String string, OOXML oOXML) {
        this(string);
    }
}

