/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.awt.Point;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import junit.framework.TestCase;
import org.jopendocument.dom.NS;
import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.SpreadSheet;

public class SheetTest
extends TestCase {
    static final DefaultTableModel tm = new DefaultTableModel();
    private Sheet sheet;

    static {
        tm.addColumn("col1");
        tm.addColumn("col2");
        tm.addColumn("col3");
        tm.addRow(new Object[]{"un1", new Float(-5.32), new Integer(123)});
    }

    @Override
    protected void setUp() throws Exception {
        this.sheet = SpreadSheet.createEmpty(tm, NS.getOOo()).getSheet(0);
    }

    @Override
    protected void tearDown() throws Exception {
        this.sheet = null;
    }

    public void testSetValueAt() {
        SheetTest.assertEquals((Object)"col1", this.sheet.getValueAt(0, 0));
        this.sheet.setValueAt("test", 0, 0);
        SheetTest.assertEquals((Object)"test", this.sheet.getValueAt(0, 0));
    }

    public void testGetImmutableCellAtIntInt() {
    }

    public void testGetImmutableCellAtString() {
    }

    public void testGetValueAtIntInt() {
        SheetTest.assertEquals(new Float(123.0f), this.sheet.getValueAt(2, 1));
    }

    public void testGetValueAtString() {
        SheetTest.assertEquals(new Float(123.0f), this.sheet.getValueAt("C2"));
        SheetTest.assertFalse(new Integer(123).equals(this.sheet.getValueAt("C2")));
    }

    public void testGetRowCount() {
        SheetTest.assertEquals(2, this.sheet.getRowCount());
    }

    public void testGetColumnCount() {
        SheetTest.assertEquals(3, this.sheet.getColumnCount());
    }

    public void testSetColumnCountInt() {
        int newSize = this.sheet.getColumnCount() + 5;
        try {
            this.sheet.setValueAt("test", newSize - 1, 0);
            SheetTest.fail("should have thrown IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.sheet.setColumnCount(newSize);
        this.sheet.setValueAt("test", newSize - 1, 0);
    }

    public void testEnsureColumnCount() {
        int before = this.sheet.getColumnCount();
        int newSize = before - 2;
        this.sheet.ensureColumnCount(newSize);
        SheetTest.assertEquals(before, this.sheet.getColumnCount());
    }

    public void testSetColumnCountIntInt() {
    }

    public void testEnsureRowCount() {
    }

    public void testSetRowCountInt() {
    }

    public void testSetRowCountIntInt() {
    }

    public void testGetTableModel() {
        TableModel t = this.sheet.getTableModel(1, 0);
        SheetTest.assertEquals(tm.getColumnCount() - 1, t.getColumnCount());
        SheetTest.assertEquals(tm.getRowCount() + 1, t.getRowCount());
        SheetTest.assertEquals(new Float(-5.32), t.getValueAt(1, 0));
    }

    public void testGetMutableTableModel() {
        this.sheet.getMutableTableModel(1, 0).setValueAt("test", 0, 1);
        SheetTest.assertEquals((Object)"test", this.sheet.getCellAt("C1").getValue());
    }

    public void testMerge() {
    }

    public void testIsCellRef() {
        SheetTest.assertTrue(Sheet.isCellRef("A23"));
        SheetTest.assertFalse(Sheet.isCellRef("A23A"));
        SheetTest.assertFalse(Sheet.isCellRef("test"));
        SheetTest.assertFalse(Sheet.isCellRef("23"));
    }

    public void testResolve() {
        SheetTest.assertEquals(Sheet.resolve("AA34"), new Point(26, 33));
    }

    public void testToInt() {
        SheetTest.assertEquals(0, Sheet.toInt("A"));
        SheetTest.assertEquals(26, Sheet.toInt("AA"));
        SheetTest.assertEquals(77, Sheet.toInt("BZ"));
    }
}

