/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import javax.swing.table.TableModel;
import org.apache.commons.collections.map.LinkedMap;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.ContentType;
import org.jopendocument.dom.ContentTypeVersioned;
import org.jopendocument.dom.NS;
import org.jopendocument.dom.OOFileDocument;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.util.ExceptionUtils;

public class SpreadSheet {
    private final OOFileDocument originalFile;
    private final String version;
    private final Document doc;
    private final Document styles;
    private final LinkedMap sheets;

    public static SpreadSheet createFromFile(File f) throws IOException {
        OOFileDocument fd = new OOFileDocument(f);
        return new SpreadSheet(fd.getDocument("content.xml"), fd.getDocument("styles.xml"), fd);
    }

    public static SpreadSheet createEmpty(TableModel t) throws IOException {
        return SpreadSheet.createEmpty(t, NS.getOD());
    }

    public static SpreadSheet createEmpty(TableModel t, NS ns) throws IOException {
        Element body;
        Document doc = new Document(new Element("document-content", ns.getOFFICE()));
        ContentTypeVersioned ct = ContentTypeVersioned.fromType(ContentType.SPREADSHEET, ns.getVersion());
        if (ct.getVersion().equals("OpenOffice.org")) {
            doc.getRootElement().setAttribute("class", ct.getShortName(), ns.getOFFICE());
        }
        doc.getRootElement().addContent(new Element("automatic-styles", ns.getOFFICE()));
        Element topBody = new Element("body", ns.getOFFICE());
        if (ct.getVersion().equals("OpenDocument")) {
            body = new Element(ct.getShortName(), ns.getOFFICE());
            topBody.addContent(body);
        } else {
            body = topBody;
        }
        doc.getRootElement().addContent(topBody);
        Element sheetElem = Sheet.createEmpty(ns);
        body.addContent(sheetElem);
        SpreadSheet spreadSheet = new SpreadSheet(doc, null);
        spreadSheet.getSheet(0).merge(t, 0, 0, true);
        return spreadSheet;
    }

    public static File export(TableModel t, File f, NS ns) throws IOException {
        return SpreadSheet.createEmpty(t, ns).saveAs(f);
    }

    public SpreadSheet(Document doc, Document styles) {
        this(doc, styles, null);
    }

    private SpreadSheet(Document doc, Document styles, OOFileDocument orig) {
        this.doc = doc;
        this.styles = styles;
        this.originalFile = orig != null ? orig : new OOFileDocument(Collections.<String, Object>emptyMap());
        this.originalFile.putFile("content.xml", this.doc);
        if (this.styles != null) {
            this.originalFile.putFile("styles.xml", this.styles);
        }
        this.version = NS.getVersion(doc);
        this.sheets = new LinkedMap();
        for (Element t : this.getBody().getChildren("table", this.getNS().getTABLE())) {
            this.sheets.put(t.getAttributeValue("name", this.getNS().getTABLE()), t);
        }
    }

    private Element getBody() {
        Element body = this.doc.getRootElement().getChild("body", this.getNS().getOFFICE());
        if (this.version.equals("OpenOffice.org")) {
            return body;
        }
        return body.getChild("spreadsheet", this.getNS().getOFFICE());
    }

    public final Element getAutoStyle(String name) {
        try {
            XPath xp = this.getXPath("./office:automatic-styles/style:style[@style:name='" + name + "']");
            return (Element)xp.selectSingleNode(this.doc.getRootElement());
        }
        catch (JDOMException e) {
            throw ExceptionUtils.createExn(IllegalStateException.class, "", e);
        }
    }

    protected final String[] resolve(String namedRange) {
        Attribute attr;
        try {
            XPath path = this.getXPath("./table:named-expressions/table:named-range[@table:name='" + namedRange + "']/@table:base-cell-address");
            attr = (Attribute)path.selectSingleNode(this.getBody());
        }
        catch (JDOMException e) {
            throw new IllegalStateException();
        }
        if (attr != null) {
            String ref = attr.getValue().replaceAll("\\$", "");
            int dotIndex = ref.indexOf(46);
            String sheetName = ref.substring(0, dotIndex);
            String cellName = ref.substring(dotIndex + 1);
            return new String[]{sheetName, cellName};
        }
        return null;
    }

    public Object getValueAt(String ref) {
        if (Sheet.isCellRef(ref)) {
            throw new IllegalArgumentException(String.valueOf(ref) + " is a cell range, you must use it on a sheet");
        }
        String[] r = this.resolve(ref);
        return this.getSheet(r[0]).getValueAt(r[1]);
    }

    protected final NS getNS() {
        return NS.get(this.version);
    }

    public XPath getXPath(String p) throws JDOMException {
        return OOUtils.getXPath(p, this.version);
    }

    public int getSheetCount() {
        return this.sheets.size();
    }

    public Sheet getSheet(int i) {
        return this.getSheet((String)this.sheets.get(i));
    }

    public Sheet getSheet(String name) {
        Object res = this.sheets.get(name);
        if (res instanceof Element) {
            res = new Sheet(this, (Element)res);
            this.sheets.put(name, res);
        }
        return (Sheet)res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putFile(String name, byte[] data) {
        OOFileDocument oOFileDocument = this.originalFile;
        synchronized (oOFileDocument) {
            this.originalFile.putFile(name, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveAs(File file) throws FileNotFoundException, IOException {
        OOFileDocument oOFileDocument = this.originalFile;
        synchronized (oOFileDocument) {
            this.originalFile.setFile(file);
            return this.originalFile.save();
        }
    }
}

