/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.template.engine;

import java.io.File;
import org.jdom.Document;
import org.jdom.Element;
import org.jopendocument.dom.NS;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.OOXMLDocument;
import org.jopendocument.util.CopyUtils;

public class Material<W>
implements Cloneable {
    private final W whole;
    private final Element root;
    private File base;

    private static final <Whole> Material<Whole> from(Whole p) {
        if (p instanceof Document) {
            return Material.from((Document)p);
        }
        if (p instanceof OOXMLDocument) {
            return Material.from((OOXMLDocument)p);
        }
        if (p instanceof ODPackage) {
            return Material.from((ODPackage)p);
        }
        return Material.from((Element)p);
    }

    public static final Material<Document> from(Document doc) {
        return new Material<Document>(doc, doc.hasRootElement() ? doc.getRootElement() : null);
    }

    public static final Material<Element> from(Element elem) {
        return new Material<Element>(elem, elem);
    }

    public static final <E extends OOXMLDocument> Material<E> from(E doc) {
        return new Material<E>(doc, doc.getDocument().getRootElement());
    }

    public static final <E extends ODPackage> Material<E> from(E doc) {
        return new Material<E>(doc, doc.getContent().getDocument().getRootElement());
    }

    private Material(W whole, Element root) {
        this.whole = whole;
        this.root = root;
        this.base = null;
    }

    public Element getRoot() {
        return this.root;
    }

    public boolean hasRoot() {
        return this.getRoot() != null;
    }

    public W getWhole() {
        return this.whole;
    }

    public NS getNS() {
        return NS.get(NS.getVersion(this.getRoot()));
    }

    public Material<W> clone() {
        Material<W> res = Material.from(CopyUtils.copy(this.getWhole()));
        res.setBase(this.getBase());
        return res;
    }

    public File getBase() {
        return this.base;
    }

    public void setBase(File base) {
        this.base = base;
    }
}

