/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.template.statements;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.OOSingleXMLDocument;
import org.jopendocument.dom.template.TemplateException;
import org.jopendocument.dom.template.engine.DataModel;
import org.jopendocument.dom.template.engine.Material;
import org.jopendocument.dom.template.engine.Parsed;
import org.jopendocument.dom.template.engine.Processor;
import org.jopendocument.dom.template.statements.Statement;
import org.jopendocument.util.ExceptionUtils;
import org.jopendocument.util.JDOMUtils;
import org.jopendocument.util.cache.CacheResult;
import org.jopendocument.util.cache.ICache;

public class Include
extends Statement {
    private static final String PREFIX = "[IOD";
    private final ICache<File, OOSingleXMLDocument, File> cache = new ICache(180);
    private final ICache<String, Parsed<OOSingleXMLDocument>, File> parsedCache = new ICache(180);

    public Include() {
        super("include");
    }

    @Override
    public boolean matches(Element elem) throws JDOMException {
        return elem.getQualifiedName().equals("text:a") && Include.getName(elem).startsWith(PREFIX);
    }

    private static String getName(Element elem) {
        String res = elem.getAttributeValue("name", elem.getNamespace("office"));
        if (res == null) {
            throw new IllegalStateException("no name attr for " + JDOMUtils.output(elem));
        }
        return res;
    }

    @Override
    public void prepare(Element script) {
        String href = script.getAttributeValue("href", script.getNamespace("xlink"));
        int sharp = href.indexOf(35);
        String path = href.substring(0, sharp);
        int pipe = href.lastIndexOf(124);
        int lastIndex = pipe < 0 ? href.lastIndexOf("%7C") : pipe;
        String section = href.substring(sharp + 1, lastIndex);
        String name = script.getAttributeValue("name", script.getNamespace("office"));
        String paramS = name.substring(PREFIX.length(), name.lastIndexOf(93)).trim();
        Element param = paramS.length() > 0 ? new Element("param").setText(paramS) : null;
        script.removeContent();
        script.getAttributes().clear();
        script.setName(this.getName());
        script.setNamespace(jooNS);
        script.setAttribute("path", path);
        script.setAttribute("section", section);
        if (param != null) {
            script.addContent(param);
        }
    }

    @Override
    public void execute(Processor<?> processor, Element tag, DataModel model) throws TemplateException {
        if (processor.getMaterial().getBase() == null) {
            throw new TemplateException("no base file for " + processor.getMaterial());
        }
        try {
            String relativePath = tag.getAttributeValue("path");
            File ref = new File(processor.getMaterial().getBase(), relativePath).getCanonicalFile();
            Parsed<OOSingleXMLDocument> parsed = this.getParsed(ref, tag.getAttributeValue("section"), processor.getParsed());
            OOSingleXMLDocument docExecuted = parsed.execute(this.getModel(model, tag));
            Object whole = processor.getMaterial().getWhole();
            OOSingleXMLDocument single = whole instanceof ODPackage ? (OOSingleXMLDocument)((ODPackage)whole).getContent() : (OOSingleXMLDocument)whole;
            single.replace(Include.getAncestorByName(tag, "p"), docExecuted);
        }
        catch (IOException e) {
            throw ExceptionUtils.createExn(TemplateException.class, "", e);
        }
        catch (JDOMException e) {
            throw ExceptionUtils.createExn(TemplateException.class, "", e);
        }
        tag.detach();
    }

    private Parsed<OOSingleXMLDocument> getParsed(File ref, String sectionName, Parsed<?> parsed) throws JDOMException, IOException, TemplateException {
        Parsed<OOSingleXMLDocument> res;
        String key = String.valueOf(ref.getPath()) + "#" + sectionName;
        CacheResult<Parsed<OOSingleXMLDocument>> cached = this.parsedCache.check(key);
        if (cached.getState() == CacheResult.State.NOT_IN_CACHE) {
            res = this.createParsed(ref, sectionName, parsed);
            this.parsedCache.put(key, res, Collections.emptySet());
        } else {
            res = cached.getRes();
        }
        return res;
    }

    private Parsed<OOSingleXMLDocument> createParsed(File ref, String sectionName, Parsed<?> parsed) throws JDOMException, IOException, TemplateException {
        OOSingleXMLDocument docToAdd = new OOSingleXMLDocument(this.getXMLDocument(ref));
        XPath sectionXP = docToAdd.getXPath("//text:section[@text:name = '" + sectionName + "']");
        Element section = (Element)sectionXP.selectSingleNode(docToAdd.getDocument());
        docToAdd.getBody().setContent(section.detach());
        Material<OOSingleXMLDocument> from = Material.from(docToAdd);
        from.setBase(ref);
        return new Parsed<OOSingleXMLDocument>(from, parsed);
    }

    private OOSingleXMLDocument getXMLDocument(File ref) throws JDOMException, IOException {
        OOSingleXMLDocument res;
        CacheResult<OOSingleXMLDocument> cached = this.cache.check(ref);
        if (cached.getState() == CacheResult.State.NOT_IN_CACHE) {
            res = OOSingleXMLDocument.createFromFile(ref);
            this.cache.put(ref, res, Collections.emptySet());
        } else {
            res = cached.getRes();
        }
        return res;
    }

    private DataModel getModel(DataModel dm, Element tag) {
        DataModel res;
        Element param = tag.getChild("param");
        if (param != null) {
            res = new DataModel(dm);
            res.getValue(param.getText());
        } else {
            res = dm;
        }
        return res;
    }
}

