/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.model.style;

import java.awt.Color;
import java.awt.Font;
import org.jopendocument.util.ValueHelper;

public class StyleTextProperties {
    private String fontName;
    private String fontSize;
    private String fontWeight;
    Font lastFont;
    double lastResizeFactor;
    private Color color;

    public void setFontName(String value) {
        this.fontName = value;
    }

    public void setFontSize(String value) {
        this.fontSize = value;
    }

    public void setFontWeight(String value) {
        this.fontWeight = value;
    }

    public String getFontName() {
        return this.fontName;
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public Font getFont(double resizeFactor) {
        Font font;
        if (this.lastResizeFactor == resizeFactor) {
            return this.lastFont;
        }
        String currentFontName = this.fontName;
        int fonttype = 0;
        if (this.fontWeight != null && this.fontWeight.equals("bold")) {
            fonttype = 1;
        }
        if (this.fontSize == null) {
            this.fontSize = "10pt";
            System.err.println("Assert default font size: 10");
        }
        String substring = this.fontSize.substring(0, this.fontSize.length() - 2);
        int fSize = Integer.valueOf(substring);
        if (currentFontName.equalsIgnoreCase("Times")) {
            currentFontName = "Times New Roman";
        }
        if (currentFontName == null) {
            throw new IllegalStateException("font name null!!");
        }
        this.lastFont = font = new Font(currentFontName, fonttype, (int)((double)(fSize * 360) / resizeFactor));
        this.lastResizeFactor = resizeFactor;
        return font;
    }

    public String toString() {
        return "StyleTextProperty:" + this.fontName + " " + this.fontSize + " " + this.fontWeight;
    }

    public void setColor(String value) {
        if (value != null) {
            this.color = ValueHelper.getColor(value);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color fontColor) {
        this.color = fontColor;
    }
}

