/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.model.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.model.office.OfficeForms;
import org.jopendocument.model.office.OfficeSpreadsheet;
import org.jopendocument.model.style.StyleMasterPage;
import org.jopendocument.model.style.StylePageLayout;
import org.jopendocument.model.style.StylePageLayoutProperties;
import org.jopendocument.model.style.StyleStyle;
import org.jopendocument.model.table.TableScenario;
import org.jopendocument.model.table.TableShapes;
import org.jopendocument.model.table.TableTableColumn;
import org.jopendocument.model.table.TableTableColumnGroup;
import org.jopendocument.model.table.TableTableColumns;
import org.jopendocument.model.table.TableTableHeaderColumns;
import org.jopendocument.model.table.TableTableHeaderRows;
import org.jopendocument.model.table.TableTableRow;
import org.jopendocument.model.table.TableTableRowGroup;
import org.jopendocument.model.table.TableTableRows;
import org.jopendocument.model.table.TableTableSource;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"tableTableSource", "tableScenario", "officeForms", "tableShapes", "tableTableColumnsOrTableTableColumnOrTableTableColumnGroupOrTableTableHeaderColumns", "tableTableRowsOrTableTableRowOrTableTableRowGroupOrTableTableHeaderRows"})
@XmlRootElement(name="table:table")
public class TableTable {
    ArrayList<TableTableColumn> columns = new ArrayList();
    ArrayList<TableTableRow> rows = new ArrayList();
    @XmlAttribute(name="table:name")
    @XmlJavaTypeAdapter(value=NormalizedStringAdapter.class)
    protected String tableName;
    @XmlAttribute(name="table:style-name")
    @XmlJavaTypeAdapter(value=NormalizedStringAdapter.class)
    protected String tableStyleName;
    @XmlAttribute(name="table:protected")
    @XmlJavaTypeAdapter(value=NormalizedStringAdapter.class)
    protected String tableProtected;
    @XmlAttribute(name="table:protection-key")
    @XmlJavaTypeAdapter(value=NormalizedStringAdapter.class)
    protected String tableProtectionKey;
    @XmlAttribute(name="table:print-ranges")
    @XmlJavaTypeAdapter(value=NormalizedStringAdapter.class)
    protected String tablePrintRanges;
    @XmlAttribute(name="table:automatic-print-range")
    @XmlJavaTypeAdapter(value=NormalizedStringAdapter.class)
    protected String tableAutomaticPrintRange;
    @XmlElement(name="table:table-source")
    protected TableTableSource tableTableSource;
    @XmlElement(name="table:scenario")
    protected TableScenario tableScenario;
    @XmlElement(name="office:forms")
    protected OfficeForms officeForms;
    @XmlElement(name="table:shapes")
    protected TableShapes tableShapes;
    @XmlElements(value={@XmlElement(name="table:table-columns", required=true, type=TableTableColumns.class), @XmlElement(name="table:table-column", required=true, type=TableTableColumn.class), @XmlElement(name="table:table-column-group", required=true, type=TableTableColumnGroup.class), @XmlElement(name="table:table-header-columns", required=true, type=TableTableHeaderColumns.class)})
    protected List<Object> tableTableColumnsOrTableTableColumnOrTableTableColumnGroupOrTableTableHeaderColumns;
    @XmlElements(value={@XmlElement(name="table:table-rows", required=true, type=TableTableRows.class), @XmlElement(name="table:table-row", required=true, type=TableTableRow.class), @XmlElement(name="table:table-row-group", required=true, type=TableTableRowGroup.class), @XmlElement(name="table:table-header-rows", required=true, type=TableTableHeaderRows.class)})
    protected List<Object> tableTableRowsOrTableTableRowOrTableTableRowGroupOrTableTableHeaderRows;
    private int printStartRow = 0;
    private int printStartCol = 0;
    private int printStopRow = 0;
    private int printStopCol = 0;
    private OfficeSpreadsheet spreadsheet;
    Vector<TableTableColumn> allColumns;

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String value) {
        this.tableName = value;
    }

    public String getTableStyleName() {
        return this.tableStyleName;
    }

    public void setTableStyleName(String value) {
        this.tableStyleName = value;
    }

    public String getTableProtected() {
        if (this.tableProtected == null) {
            return "false";
        }
        return this.tableProtected;
    }

    public void setTableProtected(String value) {
        this.tableProtected = value;
    }

    public String getTableProtectionKey() {
        return this.tableProtectionKey;
    }

    public void setTableProtectionKey(String value) {
        this.tableProtectionKey = value;
    }

    public void setTablePrintRanges(String value) {
        int val;
        char c;
        if (value == null) {
            throw new IllegalArgumentException("ranges is null");
        }
        this.tablePrintRanges = value;
        int s = value.indexOf(58);
        String l = value.substring(0, s);
        String r = value.substring(s + 1);
        String vl = l.substring(l.indexOf(46) + 1);
        String vr = r.substring(r.indexOf(46) + 1);
        int j = 0;
        int i = vl.length() - 1;
        while (i >= 0) {
            c = vl.charAt(i);
            if (Character.isLetter((int)c)) {
                val = c - 65;
                this.printStartCol = (int)((double)this.printStartCol + (double)val * Math.pow(26.0, j));
                ++j;
            } else {
                this.printStartRow = i;
            }
            --i;
        }
        String substring = vl.substring(vl.length() - this.printStartRow);
        this.printStartRow = Integer.valueOf(substring) - 1;
        j = 0;
        i = vr.length() - 1;
        while (i >= 0) {
            c = vr.charAt(i);
            if (Character.isLetter((int)c)) {
                val = c - 65;
                this.printStopCol = (int)((double)this.printStopCol + (double)val * Math.pow(26.0, j));
                ++j;
            } else {
                this.printStopRow = i;
            }
            --i;
        }
        substring = vr.substring(vl.length() - this.printStopRow);
        this.printStopRow = Integer.valueOf(substring) - 1;
    }

    public int getPrintStartCol() {
        return this.printStartCol;
    }

    public int getPrintStartRow() {
        return this.printStartRow;
    }

    public int getPrintStopCol() {
        return this.printStopCol;
    }

    public int getPrintStopRow() {
        return this.printStopRow;
    }

    public String getTableAutomaticPrintRange() {
        return this.tableAutomaticPrintRange;
    }

    public void setTableAutomaticPrintRange(String value) {
        this.tableAutomaticPrintRange = value;
    }

    public TableTableSource getTableTableSource() {
        return this.tableTableSource;
    }

    public void setTableTableSource(TableTableSource value) {
        this.tableTableSource = value;
    }

    public TableScenario getTableScenario() {
        return this.tableScenario;
    }

    public void setTableScenario(TableScenario value) {
        this.tableScenario = value;
    }

    public OfficeForms getOfficeForms() {
        return this.officeForms;
    }

    public void setOfficeForms(OfficeForms value) {
        this.officeForms = value;
    }

    public TableShapes getTableShapes() {
        return this.tableShapes;
    }

    public void setTableShapes(TableShapes value) {
        this.tableShapes = value;
    }

    public void addColumn(TableTableColumn col) {
        int i = 0;
        while (i < col.getTableNumberColumnsRepeated()) {
            this.columns.add(col);
            ++i;
        }
        col.setTable(this);
    }

    public void addRow(TableTableRow r) {
        int i = 0;
        while (i < r.getTableNumberRowsRepeated()) {
            this.rows.add(r);
            ++i;
        }
        r.setTable(this);
    }

    public List<TableTableColumn> getColumns() {
        return this.columns;
    }

    public List<TableTableRow> getRows() {
        return this.rows;
    }

    public String toString() {
        return "TableTable: print:" + this.getPrintStartCol() + "," + this.getPrintStartRow() + " : " + this.getPrintStopCol() + "," + this.getPrintStopRow();
    }

    public StyleStyle getColumnStyle(String s) {
        return this.spreadsheet.getBody().getDocument().getAutomaticStyles().getColumnStyle(s);
    }

    public StyleStyle getCellStyle(String s) {
        return this.spreadsheet.getBody().getDocument().getAutomaticStyles().getCellStyle(s);
    }

    public StyleStyle getRowStyle(String s) {
        return this.spreadsheet.getBody().getDocument().getAutomaticStyles().getRowStyle(s);
    }

    public void setSpreadsheet(OfficeSpreadsheet s) {
        this.spreadsheet = s;
    }

    public OfficeSpreadsheet getSpreadsheet() {
        return this.spreadsheet;
    }

    public List<TableTableColumn> getColumnsInRange(int startCol, int stopCol) {
        Vector<TableTableColumn> colsInRange = new Vector<TableTableColumn>(stopCol - startCol + 1);
        int i = startCol;
        while (i <= stopCol) {
            colsInRange.add(this.columns.get(i));
            ++i;
        }
        return colsInRange;
    }

    public List<TableTableRow> getRowsInRange(int startRow, int stopRow) {
        ArrayList<TableTableRow> rowsInRange = new ArrayList<TableTableRow>(stopRow - startRow + 1);
        int i = startRow;
        while (i <= stopRow) {
            if (i < this.rows.size()) {
                rowsInRange.add(this.rows.get(i));
            }
            ++i;
        }
        return rowsInRange;
    }

    public int getPrintWidth() {
        int w = 0;
        List<TableTableColumn> cols = this.getColumnsInRange(this.getPrintStartCol(), this.getPrintStopCol());
        for (TableTableColumn col : cols) {
            w += col.getWidth();
        }
        return w;
    }

    public int getPrintWidth(double resizeFactor) {
        int w = 0;
        List<TableTableColumn> cols = this.getColumnsInRange(this.getPrintStartCol(), this.getPrintStopCol());
        for (TableTableColumn col : cols) {
            w = (int)((double)w + (double)col.getWidth() / resizeFactor);
        }
        return w;
    }

    public TableTableColumn getColumn(int i) {
        return this.columns.get(i);
    }

    public int getPrintHeight() {
        int h = 0;
        List<TableTableRow> rowsInRange = this.getRowsInRange(this.getPrintStartRow(), this.getPrintStopRow());
        for (TableTableRow row : rowsInRange) {
            h += row.getHeight();
        }
        return h;
    }

    public int getPrintHeight(double resizeFactor) {
        int h = 0;
        List<TableTableRow> rowsInRange = this.getRowsInRange(this.getPrintStartRow(), this.getPrintStopRow());
        for (TableTableRow row : rowsInRange) {
            h = (int)((double)h + (double)row.getHeight() / resizeFactor);
        }
        return h;
    }

    public int getHeight(int startRow, int stopRow) {
        int h = 0;
        int i = startRow;
        while (i <= stopRow) {
            TableTableRow tableTableRow = this.rows.get(i);
            h += tableTableRow.getHeight();
            ++i;
        }
        return h;
    }

    public TableTableColumn getColumnAtPosition(int colPosition) {
        if (this.allColumns == null) {
            this.allColumns = new Vector();
            int i = 0;
            while (i < this.columns.size()) {
                TableTableColumn col = this.getColumn(i);
                int n = 0;
                while (n < col.getTableNumberColumnsRepeated()) {
                    this.allColumns.add(col);
                    ++n;
                }
                ++i;
            }
        }
        return this.allColumns.get(colPosition);
    }

    public StylePageLayoutProperties getPageLayoutProperties() {
        if (this.tableStyleName == null) {
            return null;
        }
        OpenDocument doc = this.getSpreadsheet().getBody().getDocument();
        StyleStyle tableStyle = doc.getAutomaticStyles().getTableStyle(this.tableStyleName);
        String styleMasterPageName = tableStyle.getMasterPageName();
        StyleMasterPage styleMasterPage = doc.getMasterStyles().getMasterPageFromStyleName(styleMasterPageName);
        String pageLayoutName = styleMasterPage.getStylePageLayoutName();
        StylePageLayout pageLayout = doc.getAutomaticStyles().getStylePageLayoutFromStyleName(pageLayoutName);
        return pageLayout.getPageLayoutProperties();
    }
}

