/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.renderer;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import org.jopendocument.model.style.StyleTableCellProperties;
import org.jopendocument.model.table.TableTableCell;
import org.jopendocument.renderer.ODTCellRenderer;

public class ODTCellBorderRenderer
implements ODTCellRenderer {
    private static final boolean debug = false;

    @Override
    public final void draw(Graphics2D g, int x, int y, int cellWidth, int cellHeight, double resizeFactor, TableTableCell cell, StyleTableCellProperties cellProps) {
        if (cellProps != null) {
            int w;
            if (cellProps.hasLeftBorder()) {
                g.setColor(cellProps.getBorderColorLeft());
                w = cellProps.getBorderWidthLeft();
                w = (int)((double)w / resizeFactor);
                if (w < 1) {
                    w = 1;
                }
                g.setStroke(new BasicStroke((float)((double)w / resizeFactor)));
                g.drawLine(x, y, x, y + cellHeight);
            }
            if (cellProps.hasRightBorder()) {
                g.setColor(cellProps.getBorderColorRight());
                w = cellProps.getBorderWidthRight();
                w = (int)((double)w / resizeFactor);
                if (w < 1) {
                    w = 1;
                }
                g.setStroke(new BasicStroke((float)((double)w / resizeFactor)));
                g.drawLine(x + cellWidth, y, x + cellWidth, y + cellHeight);
            }
            if (cellProps.hasTopBorder()) {
                g.setColor(cellProps.getBorderColorTop());
                w = cellProps.getBorderWidthTop();
                w = (int)((double)w / resizeFactor);
                if (w < 1) {
                    w = 1;
                }
                g.setStroke(new BasicStroke((float)((double)w / resizeFactor)));
                g.drawLine(x, y, x + cellWidth, y);
            }
            if (cellProps.hasBottomBorder()) {
                g.setColor(cellProps.getBorderColorBottom());
                w = cellProps.getBorderWidthBottom();
                w = (int)((double)w / resizeFactor);
                if (w < 1) {
                    w = 1;
                }
                g.setStroke(new BasicStroke((float)((double)w / resizeFactor)));
                g.drawLine(x, y + cellHeight, x + cellWidth, y + cellHeight);
            }
        }
    }
}

