/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.renderer;

import java.awt.Graphics2D;
import java.awt.Image;
import java.util.List;
import org.jopendocument.model.draw.DrawFrame;
import org.jopendocument.model.draw.DrawImage;
import org.jopendocument.model.style.StyleTableCellProperties;
import org.jopendocument.model.table.TableTableCell;
import org.jopendocument.renderer.ODTCellRenderer;
import org.jopendocument.util.ValueHelper;

public class ODTCellImageRenderer
implements ODTCellRenderer {
    boolean maxResolution;

    public void setPaintMaxResolution(boolean maxResolution) {
        this.maxResolution = maxResolution;
    }

    @Override
    public void draw(Graphics2D g, int x, int y, int cellWidth, int cellHeight, double resizeFactor, TableTableCell cell, StyleTableCellProperties cellProps) {
        List<DrawFrame> drawFrames = cell.getDrawFrames();
        if (drawFrames != null) {
            for (DrawFrame frame : drawFrames) {
                DrawImage dIm = frame.getDrawImage();
                if (dIm == null) continue;
                double dx = (double)ValueHelper.getLenth(frame.getSvgX()) / resizeFactor;
                double dy = (double)ValueHelper.getLenth(frame.getSvgY()) / resizeFactor;
                double w = (double)ValueHelper.getLenth(frame.getSvgWidth()) / resizeFactor;
                double h = (double)ValueHelper.getLenth(frame.getSvgHeight()) / resizeFactor;
                Image im = null;
                if (!this.maxResolution) {
                    im = cell.getRow().getTable().getSpreadsheet().getBody().getDocument().getImage(dIm.getXlinkHref(), (int)w, (int)h);
                    g.drawImage(im, x + (int)Math.round(dx), y + (int)Math.round(dy), null);
                    continue;
                }
                im = cell.getRow().getTable().getSpreadsheet().getBody().getDocument().getImage(dIm.getXlinkHref());
                g.drawImage(im, x + (int)Math.round(dx), y + (int)Math.round(dy), (int)Math.round(w), (int)Math.round(h), null);
            }
        }
    }
}

