/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.model.PrintedPage;
import org.jopendocument.model.draw.DrawFrame;
import org.jopendocument.model.draw.DrawImage;
import org.jopendocument.model.office.OfficeBody;
import org.jopendocument.model.office.OfficeSpreadsheet;
import org.jopendocument.model.style.StylePageLayoutProperties;
import org.jopendocument.model.style.StyleStyle;
import org.jopendocument.model.style.StyleTableCellProperties;
import org.jopendocument.model.table.TableShapes;
import org.jopendocument.model.table.TableTable;
import org.jopendocument.model.table.TableTableCell;
import org.jopendocument.model.table.TableTableColumn;
import org.jopendocument.model.table.TableTableRow;
import org.jopendocument.renderer.ODTCellBackgroundRenderer;
import org.jopendocument.renderer.ODTCellBorderRenderer;
import org.jopendocument.renderer.ODTCellImageRenderer;
import org.jopendocument.renderer.ODTCellRenderer;
import org.jopendocument.renderer.ODTCellTextRenderer;
import org.jopendocument.util.ValueHelper;

public class ODTRenderer
extends JPanel {
    private static final long serialVersionUID = -4903349568929293597L;
    private double resizeFactor;
    private OfficeBody body;
    private TableTable table;
    private int printHeightPixel;
    private int printWidthPixel;
    private int printWidth;
    private int printHeight;
    private static final ODTCellBackgroundRenderer backgroundRenderer = new ODTCellBackgroundRenderer();
    private static final ODTCellBorderRenderer borderRenderer = new ODTCellBorderRenderer();
    private static final ODTCellTextRenderer textRenderer = new ODTCellTextRenderer();
    private static final ODTCellImageRenderer imageRenderer = new ODTCellImageRenderer();
    private static final boolean DEBUG = false;
    private PrintedPage currentPage;
    private boolean paintMaxResolution;
    private boolean ignoreMargins;
    private OpenDocument od;

    public ODTRenderer(OpenDocument doc) {
        this.body = doc.getBody();
        this.setBackground(Color.WHITE);
        this.currentPage = doc.getPrintedPage(0);
        this.setResizeFactor(360.0);
        this.od = doc;
    }

    public void setCurrentPage(int i) {
        this.currentPage = this.od.getPrintedPage(i);
        this.repaint();
    }

    public void setCurrentPage(PrintedPage p) {
        this.currentPage = p;
        this.repaint();
    }

    public int getPrintedPagesNumber() {
        return this.od.getPrintedPageCount();
    }

    public synchronized void setResizeFactor(double resizeFactor) {
        System.err.println("setResizeFactor from" + this.resizeFactor + " to " + resizeFactor);
        this.resizeFactor = resizeFactor;
        List<OfficeSpreadsheet> l = this.body.getOfficeSpreadsheets();
        for (OfficeSpreadsheet sheet : l) {
            TableTable t;
            System.out.println(sheet);
            List<TableTable> tables = sheet.getTables();
            Iterator<TableTable> iterator = tables.iterator();
            if (!iterator.hasNext()) continue;
            this.table = t = iterator.next();
            if (this.ignoreMargins) {
                this.printWidthPixel = t.getPrintWidth(resizeFactor);
                this.printHeightPixel = t.getPrintHeight(resizeFactor);
                this.printWidth = t.getPrintWidth();
                this.printHeight = t.getPrintHeight();
            } else {
                this.printWidth = t.getPrintWidth();
                this.printHeight = t.getPrintHeight();
                if (t.getPageLayoutProperties() != null) {
                    this.printWidth += t.getPageLayoutProperties().getMarginLeft() + t.getPageLayoutProperties().getMarginRight();
                    this.printHeight = t.getPageLayoutProperties().getPageHeight();
                }
                this.printWidthPixel = (int)Math.round((double)this.printWidth / resizeFactor);
                this.printHeightPixel = (int)Math.round((double)this.printHeight / resizeFactor);
            }
            System.out.println("Table p width:" + t.getPrintWidth() + " micrometer" + t.getPrintWidth(resizeFactor));
            System.out.println("Table p height:" + t.getPrintHeight() + " micrometer" + t.getPrintHeight(resizeFactor));
            System.out.println(String.valueOf(this.printWidthPixel) + "-" + this.printHeightPixel);
            this.setPreferredSize(new Dimension(this.printWidthPixel, this.printHeightPixel));
        }
        this.repaint();
    }

    public int getPrintWidthInPixel() {
        return this.printWidthPixel;
    }

    public int getPrintHeightInPixel() {
        return this.printHeightPixel;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.drawODTBackground(g2);
        this.drawODTBorders(g2);
        this.drawODTText(g2);
        this.drawODTImages(g2);
    }

    private final void drawODTImages(Graphics2D g2) {
        if (!this.paintMaxResolution) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        }
        this.drawCells(g2, imageRenderer);
        TableTable currentTable = this.table;
        TableShapes shapes = currentTable.getTableShapes();
        if (shapes == null) {
            return;
        }
        List<DrawFrame> frames = shapes.getDrawFrames();
        double currentResizeFactor = this.resizeFactor;
        int borderLeft = (int)((double)currentTable.getPageLayoutProperties().getMarginLeft() / currentResizeFactor);
        int borderRight = (int)((double)currentTable.getPageLayoutProperties().getMarginRight() / currentResizeFactor);
        int borderTop = (int)((double)currentTable.getPageLayoutProperties().getMarginTop() / currentResizeFactor);
        int borderBottom = (int)((double)currentTable.getPageLayoutProperties().getMarginBottom() / currentResizeFactor);
        if (this.ignoreMargins) {
            borderLeft = 0;
            borderRight = 0;
            borderTop = 0;
            borderBottom = 0;
        }
        for (DrawFrame frame : frames) {
            DrawImage dIm = frame.getDrawImage();
            if (dIm == null) continue;
            double dx = (double)borderLeft + (double)ValueHelper.getLenth(frame.getSvgX()) / this.resizeFactor;
            double dy = (double)borderTop + (double)ValueHelper.getLenth(frame.getSvgY()) / this.resizeFactor;
            double w = (double)ValueHelper.getLenth(frame.getSvgWidth()) / this.resizeFactor;
            double h = (double)ValueHelper.getLenth(frame.getSvgHeight()) / this.resizeFactor;
            Image im = null;
            if (!this.paintMaxResolution) {
                im = this.body.getDocument().getImage(dIm.getXlinkHref(), (int)w, (int)h);
                g2.drawImage(im, (int)Math.round(dx), (int)Math.round(dy), null);
                continue;
            }
            im = this.body.getDocument().getImage(dIm.getXlinkHref());
            g2.drawImage(im, (int)Math.round(dx), (int)Math.round(dy), (int)Math.round(w), (int)Math.round(h), null);
        }
    }

    private final void drawODTText(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.drawCells(g2, textRenderer);
    }

    private final void drawODTBorders(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.drawCells(g2, borderRenderer);
    }

    private final void drawODTBackground(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.drawCells(g2, backgroundRenderer);
    }

    private final void drawCells(Graphics2D g, ODTCellRenderer renderer) {
        TableTable currentTable = this.table;
        int printStartCol = currentTable.getPrintStartCol();
        int printStopCol = currentTable.getPrintStopCol();
        TableTableRow[] rows = this.currentPage.getRows();
        int rowCount = rows.length;
        double currentResizeFactor = this.resizeFactor;
        StylePageLayoutProperties pageLayoutProperties = currentTable.getPageLayoutProperties();
        int marginLeft = 0;
        int marginTop = 0;
        if (pageLayoutProperties != null) {
            marginLeft = pageLayoutProperties.getMarginLeft();
            marginTop = pageLayoutProperties.getMarginTop();
        }
        if (this.ignoreMargins) {
            marginLeft = 0;
            marginTop = 0;
        }
        int borderLeft = (int)((double)marginLeft / currentResizeFactor);
        TableTableColumn[] columns = this.table.getColumns().toArray(new TableTableColumn[0]);
        int y = (int)((double)marginTop / currentResizeFactor);
        int rowIndex = 0;
        while (rowIndex < rowCount) {
            TableTableRow row = rows[rowIndex];
            int rowHeight = (int)((double)row.getHeight() / currentResizeFactor);
            TableTableCell[] cells = row.getCellsInRange(printStartCol, printStopCol);
            int cellsSize = cells.length;
            int x = borderLeft;
            int i = 0;
            while (i < cellsSize) {
                int repeat;
                TableTableCell cell = cells[i];
                TableTableColumn col = columns[printStartCol + i];
                StyleStyle style = cell.getStyle();
                int cellWidth = (int)((double)col.getWidth() / currentResizeFactor);
                StyleTableCellProperties cellProps = style.getStyleTableCellProperties();
                int cellHeight = rowHeight;
                if (cell.getTableNumberRowsSpanned() > 1) {
                    repeat = 1;
                    while (repeat < cell.getTableNumberRowsSpanned()) {
                        cellHeight = (int)((double)cellHeight + (double)rows[rowIndex + repeat].getHeight() / currentResizeFactor);
                        ++repeat;
                    }
                }
                if (cell.getTableNumberColumnsSpanned() > 1) {
                    repeat = 1;
                    while (repeat < cell.getTableNumberColumnsSpanned()) {
                        int colIndex = printStartCol + i + repeat;
                        double w = (double)columns[colIndex].getWidth() / currentResizeFactor;
                        cellWidth = (int)((double)cellWidth + w);
                        ++repeat;
                    }
                }
                try {
                    renderer.draw(g, x, y, cellWidth, cellHeight, currentResizeFactor, cell, cellProps);
                }
                catch (Exception e) {
                    System.err.println("Failed on x:" + x + " y:" + y + " Cell:" + cell);
                    e.printStackTrace();
                }
                x += cellWidth;
                ++i;
            }
            y += rowHeight;
            ++rowIndex;
        }
    }

    public double getPrintWidth() {
        return this.printWidth;
    }

    public double getPrintHeight() {
        return this.printHeight;
    }

    public void setPaintMaxResolution(boolean b) {
        this.paintMaxResolution = b;
        imageRenderer.setPaintMaxResolution(b);
    }

    public void setIgnoreMargins(boolean b) {
        this.ignoreMargins = b;
        this.setResizeFactor(this.resizeFactor);
    }
}

